/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.mutations;

import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutationCondition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class MutationConditionTemperature
implements IMutationCondition {
    private final EnumTemperature minTemperature;
    private final EnumTemperature maxTemperature;

    public MutationConditionTemperature(EnumTemperature minTemperature, EnumTemperature maxTemperature) {
        this.minTemperature = minTemperature;
        this.maxTemperature = maxTemperature;
    }

    @Override
    public float getChance(World world, int x, int y, int z, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        BiomeGenBase biome = world.getWorldChunkManager().getBiomeGenAt(x, z);
        EnumTemperature biomeTemperature = EnumTemperature.getFromBiome(biome, x, y, z);
        if (biomeTemperature.ordinal() < this.minTemperature.ordinal() || biomeTemperature.ordinal() > this.maxTemperature.ordinal()) {
            return 0.0f;
        }
        return 1.0f;
    }

    @Override
    public String getDescription() {
        if (this.minTemperature != this.maxTemperature) {
            return String.format("Temperature between %s and %s.", new Object[]{this.minTemperature, this.maxTemperature});
        }
        return String.format("Temperature %s required.", new Object[]{this.minTemperature});
    }
}

