/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.mutations;

import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutationCondition;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class MutationConditionBiome
implements IMutationCondition {
    private final List<BiomeDictionary.Type> validBiomeTypes;

    public MutationConditionBiome(BiomeDictionary.Type ... types) {
        this.validBiomeTypes = Arrays.asList(types);
    }

    @Override
    public float getChance(World world, int x, int y, int z, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        BiomeGenBase biome = world.getBiomeGenForCoords(x, z);
        for (BiomeDictionary.Type type : this.validBiomeTypes) {
            if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)type)) continue;
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public String getDescription() {
        if (this.validBiomeTypes.size() > 1) {
            String biomeTypes = Arrays.toString(this.validBiomeTypes.toArray());
            return String.format("Is restricted to biomes like: %s", biomeTypes);
        }
        String biomeType = this.validBiomeTypes.get(0).toString();
        return String.format("Is restricted to %s-like biomes.", biomeType);
    }
}

