/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.List;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class WorldGenPapaya
extends WorldGenTree {
    public WorldGenPapaya(ITreeGenData tree) {
        super(tree, 7, 2);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth);
        List<ChunkCoordinates> branchCoords = this.generateBranches(world, this.height, 0, 0, 0.15f, 0.25f, this.height / 4, 1, 0.25f);
        for (ChunkCoordinates branchEnd : branchCoords) {
            this.generateAdjustedCylinder(world, branchEnd.posY, branchEnd.posX, branchEnd.posZ, 1.0f, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        }
        int yCenter = this.height - this.girth;
        yCenter = yCenter > 3 ? yCenter : 4;
        this.generateSphere(world, this.getCenteredAt(yCenter, 0, 0), Math.round((float)(2 + world.rand.nextInt(this.girth)) * ((float)this.height / 8.0f)), this.leaf, WorldGenBase.EnumReplaceMode.NONE);
    }
}

