/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.List;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class WorldGenBaobab
extends WorldGenTree {
    public WorldGenBaobab(ITreeGenData tree) {
        super(tree, 6, 6);
    }

    @Override
    public void generate(World world) {
        int times;
        this.generateTreeTrunk(world, this.height - 1, this.girth);
        List<ChunkCoordinates> branchCoords = this.generateBranches(world, this.height, 0, 0, 0.0f, 0.5f, 4, 6);
        for (ChunkCoordinates branchEnd : branchCoords) {
            this.generateAdjustedCylinder(world, branchEnd.posY, branchEnd.posX, branchEnd.posZ, 0.0f, 2, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        }
        if (world.rand.nextFloat() < 0.3f) {
            this.generateCylinder(world, new WorldGenBase.Vector(0.0f, this.height - 1, 0.0f), this.girth, 1, this.wood, WorldGenBase.EnumReplaceMode.SOFT);
        } else if (world.rand.nextBoolean()) {
            this.generateCylinder(world, new WorldGenBase.Vector(0.0f, this.height - 1, 0.0f), this.girth - 1, 1, this.wood, WorldGenBase.EnumReplaceMode.SOFT);
        }
        int leafSpawn = this.height + 1;
        this.generateAdjustedCylinder(world, leafSpawn--, 2.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.5f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.0f, 1, this.leaf);
        for (times = 0; times < this.height / 2; ++times) {
            int h = this.height - 1 + world.rand.nextInt(4);
            if (world.rand.nextBoolean() && h < this.height / 2) {
                h = this.height / 2 + world.rand.nextInt(this.height / 2);
            }
            int x_off = -this.girth + world.rand.nextInt(2 * this.girth);
            int y_off = -this.girth + world.rand.nextInt(2 * this.girth);
            WorldGenBase.Vector center = new WorldGenBase.Vector(x_off, h, y_off);
            int radius = 1;
            if (this.girth > 1) {
                radius += world.rand.nextInt(this.girth - 1);
            }
            this.generateSphere(world, center, radius, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        }
        for (times = 0; times < this.height / 4; ++times) {
            int delim;
            int h = delim + ((delim = this.modifyByHeight(world, 6, 0, this.height)) < this.height ? world.rand.nextInt(this.height - delim) : 0);
            if (world.rand.nextBoolean() && h < this.height / 2) {
                h = this.height / 2 + world.rand.nextInt(this.height / 2);
            }
            int x_off = -1 + world.rand.nextInt(3);
            int y_off = -1 + world.rand.nextInt(3);
            WorldGenBase.Vector center = new WorldGenBase.Vector(x_off, h, y_off);
            int radius = 1 + world.rand.nextInt(2);
            this.generateSphere(world, center, radius, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        }
    }
}

