/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.items;

import forestry.api.arboriculture.TreeManager;
import forestry.api.core.ForestryAPI;
import forestry.api.core.Tabs;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.config.Config;
import forestry.core.gui.IHintSource;
import forestry.core.items.ItemAlyzer;
import forestry.core.network.GuiId;
import forestry.core.utils.GeneticsUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemTreealyzer
extends ItemAlyzer {
    public ItemTreealyzer() {
        this.setMaxStackSize(1);
        this.setCreativeTab(Tabs.tabArboriculture);
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!world.isRemote) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.TreealyzerGUI.ordinal(), world, (int)entityplayer.posX, (int)entityplayer.posY, (int)entityplayer.posZ);
        }
        return itemstack;
    }

    public static class TreealyzerInventory
    extends ItemAlyzer.AlyzerInventory
    implements IHintSource {
        public TreealyzerInventory(EntityPlayer player, ItemStack itemStack) {
            super(player, 7, itemStack);
        }

        @Override
        protected ISpeciesRoot getSpeciesRoot() {
            return TreeManager.treeRoot;
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            ItemStack ersatz;
            if (!TreeManager.treeRoot.isMember(itemStack) && (ersatz = GeneticsUtil.convertSaplingToGeneticEquivalent(itemStack)) != null) {
                return super.canSlotAccept(slotIndex, ersatz);
            }
            return super.canSlotAccept(slotIndex, itemStack);
        }

        @Override
        public void onSlotClick(EntityPlayer player) {
            ItemStack ersatz;
            ItemStack specimen = this.getStackInSlot(0);
            if (!TreeManager.treeRoot.isMember(specimen) && (ersatz = GeneticsUtil.convertSaplingToGeneticEquivalent(specimen)) != null) {
                this.setInventorySlotContents(0, ersatz);
            }
            super.onSlotClick(player);
        }

        @Override
        public boolean hasHints() {
            return Config.hints.get("treealyzer") != null && Config.hints.get("treealyzer").length > 0;
        }

        @Override
        public String[] getHints() {
            return Config.hints.get("treealyzer");
        }
    }
}

