/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import forestry.apiculture.gui.ContainerHabitatLocator;
import forestry.apiculture.items.ItemHabitatLocator;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.widgets.Widget;
import forestry.core.proxy.Proxies;
import forestry.core.render.SpriteSheet;
import forestry.core.render.TextureManager;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import org.lwjgl.opengl.GL11;

public class GuiHabitatLocator
extends GuiForestry<ContainerHabitatLocator, ItemHabitatLocator.HabitatLocatorInventory> {
    private final HabitatSlot[] habitatSlots = new HabitatSlot[]{new HabitatSlot(0, "Ocean"), new HabitatSlot(1, "Plains"), new HabitatSlot(2, "Desert"), new HabitatSlot(3, "Forest"), new HabitatSlot(4, "Jungle"), new HabitatSlot(5, "Taiga"), new HabitatSlot(6, "Hills"), new HabitatSlot(7, "Swamp"), new HabitatSlot(8, "Snow"), new HabitatSlot(9, "Mushroom"), new HabitatSlot(10, "Nether"), new HabitatSlot(11, "End")};
    private final Map<BiomeDictionary.Type, HabitatSlot> biomeToHabitat = new EnumMap<BiomeDictionary.Type, HabitatSlot>(BiomeDictionary.Type.class);
    private int startX;
    private int startY;

    public GuiHabitatLocator(EntityPlayer player, ItemHabitatLocator.HabitatLocatorInventory item) {
        super("textures/gui/biomefinder.png", new ContainerHabitatLocator(player, item), item);
        this.xSize = 176;
        this.ySize = 184;
        for (HabitatSlot slot : this.habitatSlots) {
            int y;
            int x;
            if (slot.slot > 5) {
                x = 18 + (slot.slot - 6) * 20;
                y = 50;
            } else {
                x = 18 + slot.slot * 20;
                y = 32;
            }
            slot.setPosition(x, y);
            this.widgetManager.add(slot);
        }
        this.biomeToHabitat.put(BiomeDictionary.Type.OCEAN, this.habitatSlots[0]);
        this.biomeToHabitat.put(BiomeDictionary.Type.BEACH, this.habitatSlots[0]);
        this.biomeToHabitat.put(BiomeDictionary.Type.PLAINS, this.habitatSlots[1]);
        this.biomeToHabitat.put(BiomeDictionary.Type.SANDY, this.habitatSlots[2]);
        this.biomeToHabitat.put(BiomeDictionary.Type.FOREST, this.habitatSlots[3]);
        this.biomeToHabitat.put(BiomeDictionary.Type.RIVER, this.habitatSlots[3]);
        this.biomeToHabitat.put(BiomeDictionary.Type.JUNGLE, this.habitatSlots[4]);
        this.biomeToHabitat.put(BiomeDictionary.Type.CONIFEROUS, this.habitatSlots[5]);
        this.biomeToHabitat.put(BiomeDictionary.Type.MOUNTAIN, this.habitatSlots[6]);
        this.biomeToHabitat.put(BiomeDictionary.Type.SWAMP, this.habitatSlots[7]);
        this.biomeToHabitat.put(BiomeDictionary.Type.SNOWY, this.habitatSlots[8]);
        this.biomeToHabitat.put(BiomeDictionary.Type.MUSHROOM, this.habitatSlots[9]);
        this.biomeToHabitat.put(BiomeDictionary.Type.NETHER, this.habitatSlots[10]);
        this.biomeToHabitat.put(BiomeDictionary.Type.END, this.habitatSlots[11]);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(var1, mouseX, mouseY);
        String str = StatCollector.translateToLocal((String)"item.for.habitatLocator.name").toUpperCase();
        this.fontRendererObj.drawString(str, this.startX + 8 + this.getCenteredOffset(str, 138), this.startY + 16, this.fontColor.get("gui.screen"));
        EnumSet<BiomeDictionary.Type> activeBiomeTypes = EnumSet.noneOf(BiomeDictionary.Type.class);
        for (HabitatSlot habitatSlot : this.habitatSlots) {
            habitatSlot.isActive = false;
        }
        for (BiomeGenBase biome : ((ItemHabitatLocator.HabitatLocatorInventory)this.inventory).getBiomesToSearch()) {
            Collections.addAll(activeBiomeTypes, BiomeDictionary.getTypesForBiome((BiomeGenBase)biome));
        }
        for (BiomeDictionary.Type biomeType : activeBiomeTypes) {
            HabitatSlot habitatSlot = this.biomeToHabitat.get(biomeType);
            if (habitatSlot == null) continue;
            habitatSlot.isActive = true;
        }
        for (HabitatSlot slot : this.habitatSlots) {
            slot.draw(this.startX, this.startY);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void initGui() {
        super.initGui();
        this.startX = (this.width - this.xSize) / 2;
        this.startY = (this.height - this.ySize) / 2;
    }

    public class HabitatSlot
    extends Widget {
        private final int slot;
        private final String name;
        private final String iconIndex;
        public boolean isActive;

        public HabitatSlot(int slot, String name) {
            super(GuiHabitatLocator.this.widgetManager, 0, 0);
            this.isActive = false;
            this.slot = slot;
            this.name = name;
            this.iconIndex = "habitats/" + name.toLowerCase(Locale.ENGLISH);
        }

        @Override
        public String getLegacyTooltip(EntityPlayer player) {
            return this.name;
        }

        public IIcon getIcon() {
            return TextureManager.getInstance().getDefault(this.iconIndex);
        }

        public void setPosition(int x, int y) {
            this.xPos = x;
            this.yPos = y;
        }

        @Override
        public void draw(int startX, int startY) {
            if (this.getIcon() != null) {
                GL11.glDisable((int)2896);
                if (!this.isActive) {
                    GL11.glColor4f((float)0.2f, (float)0.2f, (float)0.2f, (float)0.2f);
                } else {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                Proxies.render.bindTexture(SpriteSheet.ITEMS);
                this.manager.gui.drawTexturedModelRectFromIcon(startX + this.xPos, startY + this.yPos, this.getIcon(), 16, 16);
                GL11.glEnable((int)2896);
            }
        }
    }
}

