/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.utils.vect.Vect;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class AlleleEffectFertile
extends AlleleEffectThrottled {
    private static final int MAX_BLOCK_FIND_TRIES = 5;

    public AlleleEffectFertile() {
        super("fertile", false, 6, true, false);
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        ChunkCoordinates housingCoordinates = housing.getCoordinates();
        Vect area = this.getModifiedArea(genome, housing);
        int blockX = AlleleEffectFertile.getRandomOffset(world.rand, housingCoordinates.posX, area.getX());
        int blockZ = AlleleEffectFertile.getRandomOffset(world.rand, housingCoordinates.posZ, area.getZ());
        int blockMaxY = housingCoordinates.posY + area.getY() / 2 + 1;
        int blockMinY = housingCoordinates.posY - area.getY() / 2 - 1;
        for (int attempt = 0; attempt < 5 && !AlleleEffectFertile.tryTickColumn(world, blockX, blockZ, blockMaxY, blockMinY); ++attempt) {
            blockX = AlleleEffectFertile.getRandomOffset(world.rand, housingCoordinates.posX, area.getX());
            blockZ = AlleleEffectFertile.getRandomOffset(world.rand, housingCoordinates.posZ, area.getZ());
        }
        return storedData;
    }

    private static int getRandomOffset(Random random, int centrePos, int offset) {
        return centrePos + random.nextInt(offset) - offset / 2;
    }

    private static boolean tryTickColumn(World world, int x, int z, int maxY, int minY) {
        for (int y = maxY; y >= minY; --y) {
            if (world.isAirBlock(x, y, z)) continue;
            Block block = world.getBlock(x, y, z);
            world.scheduleBlockUpdate(x, y, z, block, 5);
            return true;
        }
        return false;
    }
}

