/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import cpw.mods.fml.common.eventhandler.Event;
import forestry.api.storage.BackpackResupplyEvent;
import forestry.core.interfaces.IResupplyHandler;
import forestry.core.inventory.ItemInventoryBackpack;
import forestry.storage.BackpackMode;
import forestry.storage.items.ItemBackpack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;

public class ResupplyHandler
implements IResupplyHandler {
    private static List<ItemStack> backpacks(InventoryPlayer playerInventory) {
        ArrayList<ItemStack> backpacks = new ArrayList<ItemStack>();
        for (ItemStack itemStack : playerInventory.mainInventory) {
            if (itemStack == null || itemStack.stackSize <= 0 || !(itemStack.getItem() instanceof ItemBackpack)) continue;
            backpacks.add(itemStack);
        }
        return backpacks;
    }

    @Override
    public void resupply(EntityPlayer player) {
        if (!(player.openContainer instanceof ContainerPlayer)) {
            return;
        }
        for (ItemStack backpack : ResupplyHandler.backpacks(player.inventory)) {
            if (ItemBackpack.getMode(backpack) != BackpackMode.RESUPPLY) continue;
            if (backpack.getItemDamage() < 40) {
                backpack.setItemDamage(backpack.getItemDamage() + 1);
                continue;
            }
            ItemBackpack backpackItem = (ItemBackpack)backpack.getItem();
            ItemInventoryBackpack backpackInventory = new ItemInventoryBackpack(player, backpackItem.getBackpackSize(), backpack);
            BackpackResupplyEvent event = new BackpackResupplyEvent(player, backpackItem.getDefinition(), backpackInventory);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) continue;
            for (int i = 0; i < backpackInventory.getSizeInventory(); ++i) {
                boolean change;
                ItemStack itemStack = backpackInventory.getStackInSlot(i);
                if (itemStack == null || itemStack.stackSize <= 0 || !(change = ResupplyHandler.topOffPlayerInventory(player, itemStack))) continue;
                backpackInventory.setInventorySlotContents(i, itemStack);
            }
        }
    }

    private static boolean topOffPlayerInventory(EntityPlayer player, ItemStack itemstack) {
        for (int i = 0; i < player.inventory.getSizeInventory(); ++i) {
            ItemStack inventoryStack = player.inventory.getStackInSlot(i);
            if (inventoryStack == null || inventoryStack.stackSize >= inventoryStack.getMaxStackSize() || !inventoryStack.isItemEqual(itemstack) || !ItemStack.areItemStackTagsEqual((ItemStack)inventoryStack, (ItemStack)itemstack)) continue;
            ++inventoryStack.stackSize;
            --itemstack.stackSize;
            return true;
        }
        return false;
    }
}

