/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.network;

import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketId;
import forestry.mail.gadgets.MachineTrader;
import java.io.IOException;

public class PacketTraderAddress
extends PacketCoordinates {
    private String addressName;

    public PacketTraderAddress(DataInputStreamForestry data) throws IOException {
        super(data);
    }

    public PacketTraderAddress(MachineTrader tile, String addressName) {
        super(PacketId.TRADING_ADDRESS_SET, tile);
        this.addressName = addressName;
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeUTF(this.addressName);
    }

    @Override
    protected void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.addressName = data.readUTF();
    }

    public String getAddressName() {
        return this.addressName;
    }
}

