/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.PostManager;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.InventoryAdapter;
import forestry.mail.Letter;
import forestry.mail.MailAddress;
import forestry.mail.POBoxInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldSavedData;

public class POBox
extends WorldSavedData
implements IInventory {
    public static final String SAVE_NAME = "POBox_";
    public static final short SLOT_SIZE = 84;
    private IMailAddress address;
    private final InventoryAdapter letters = new InventoryAdapter(84, "Letters").disableAutomation();

    public POBox(IMailAddress address) {
        super(SAVE_NAME + address);
        if (!address.isPlayer()) {
            throw new IllegalArgumentException("POBox address must be a player");
        }
        this.address = address;
    }

    public POBox(String savename) {
        super(savename);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.hasKey("address")) {
            this.address = MailAddress.loadFromNBT(nbttagcompound.getCompoundTag("address"));
        }
        this.letters.readFromNBT(nbttagcompound);
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        if (this.address != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.address.writeToNBT(nbt);
            nbttagcompound.setTag("address", (NBTBase)nbt);
        }
        this.letters.writeToNBT(nbttagcompound);
    }

    public boolean storeLetter(ItemStack letterstack) {
        ILetter letter = PostManager.postRegistry.getLetter(letterstack);
        letter.setProcessed(true);
        letter.invalidatePostage();
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        letter.writeToNBT(nbttagcompound);
        letterstack.setTagCompound(nbttagcompound);
        this.markDirty();
        return InvTools.tryAddStack((IInventory)this.letters, letterstack, true);
    }

    public POBoxInfo getPOBoxInfo() {
        int playerLetters = 0;
        int tradeLetters = 0;
        for (int i = 0; i < this.letters.getSizeInventory(); ++i) {
            if (this.letters.getStackInSlot(i) == null) continue;
            Letter letter = new Letter(this.letters.getStackInSlot(i).getTagCompound());
            if (letter.getSender().isPlayer()) {
                ++playerLetters;
                continue;
            }
            ++tradeLetters;
        }
        return new POBoxInfo(playerLetters, tradeLetters);
    }

    public void markDirty() {
        super.markDirty();
        this.letters.markDirty();
    }

    public void setInventorySlotContents(int var1, ItemStack var2) {
        this.markDirty();
        this.letters.setInventorySlotContents(var1, var2);
    }

    public int getSizeInventory() {
        return this.letters.getSizeInventory();
    }

    public ItemStack getStackInSlot(int var1) {
        return this.letters.getStackInSlot(var1);
    }

    public ItemStack decrStackSize(int var1, int var2) {
        return this.letters.decrStackSize(var1, var2);
    }

    public ItemStack getStackInSlotOnClosing(int var1) {
        return this.letters.getStackInSlotOnClosing(var1);
    }

    public String getInventoryName() {
        return this.letters.getInventoryName();
    }

    public int getInventoryStackLimit() {
        return this.letters.getInventoryStackLimit();
    }

    public boolean isUseableByPlayer(EntityPlayer var1) {
        return this.letters.isUseableByPlayer(var1);
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean hasCustomInventoryName() {
        return true;
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return this.letters.isItemValidForSlot(i, itemstack);
    }
}

