/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.lepidopterology.entities.AIButterflyBase;
import forestry.lepidopterology.entities.EntityButterfly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockWall;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;

public class AIButterflyRest
extends AIButterflyBase {
    public AIButterflyRest(EntityButterfly entity) {
        super(entity);
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        int z;
        if (this.entity.getExhaustion() < 1000 && this.entity.canFly()) {
            return false;
        }
        int x = (int)this.entity.posX;
        int y = (int)Math.floor(this.entity.posY);
        if (!this.canLand(x, y, z = (int)this.entity.posZ)) {
            return false;
        }
        if (this.entity.worldObj.isAirBlock(x, --y, z)) {
            return false;
        }
        if (this.entity.worldObj.getBlock(x, y, z).getMaterial().isLiquid()) {
            return false;
        }
        if (!this.entity.getButterfly().isAcceptedEnvironment(this.entity.worldObj, x, y, z)) {
            return false;
        }
        this.entity.setDestination(null);
        this.entity.setState(EntityButterfly.EnumButterflyState.RESTING);
        return true;
    }

    public boolean continueExecuting() {
        if (this.entity.getExhaustion() <= 0 && this.entity.canFly()) {
            return false;
        }
        return !this.entity.isInWater();
    }

    public void startExecuting() {
    }

    public void resetTask() {
    }

    public void updateTask() {
        this.entity.changeExhaustion(-1);
    }

    private boolean canLand(int x, int y, int z) {
        Block block = this.entity.worldObj.getBlock(x, y, z);
        if (!block.getBlocksMovement((IBlockAccess)this.entity.worldObj, x, y, z)) {
            return false;
        }
        if (AIButterflyRest.isPlant(block)) {
            return true;
        }
        block = this.entity.worldObj.getBlock(x, y - 1, z);
        return AIButterflyRest.isRest(block) || block.isLeaves((IBlockAccess)this.entity.worldObj, x, y - 1, z);
    }

    private static boolean isRest(Block block) {
        if (block instanceof BlockFence) {
            return true;
        }
        return block instanceof BlockWall;
    }

    private static boolean isPlant(Block block) {
        if (block instanceof BlockFlower) {
            return true;
        }
        if (block instanceof IPlantable) {
            return true;
        }
        if (block instanceof IGrowable) {
            return true;
        }
        return block.getMaterial() == Material.plants;
    }
}

