/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.StackUtils;
import forestry.core.vect.Vect;
import forestry.farming.logic.CropBasicGrowthCraft;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FarmableBasicGrowthCraft
implements IFarmable {
    private final Block block;
    private final int matureMeta;
    private final boolean isRice;
    private final boolean isGrape;

    public FarmableBasicGrowthCraft(Block block, int matureMeta, boolean isRice, boolean isGrape) {
        this.block = block;
        this.matureMeta = matureMeta;
        this.isRice = isRice;
        this.isGrape = isGrape;
    }

    @Override
    public boolean isSaplingAt(World world, int x, int y, int z) {
        return world.getBlock(x, y, z) == this.block;
    }

    @Override
    public ICrop getCropAt(World world, int x, int y, int z) {
        if (world.getBlock(x, y, z) != this.block) {
            return null;
        }
        if (world.getBlockMetadata(x, y, z) != this.matureMeta) {
            return null;
        }
        return new CropBasicGrowthCraft(world, this.block, this.matureMeta, new Vect(x, y, z), this.isRice, this.isGrape);
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return StackUtils.equals(this.block, itemstack);
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, int x, int y, int z) {
        return world.setBlock(x, y, z, this.block, 0, 2);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }
}

