/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.core.proxy.Proxies;
import forestry.core.vect.Vect;
import forestry.farming.logic.Crop;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class CropBasicGrowthCraft
extends Crop {
    private final Block block;
    private final int meta;
    private final boolean isRice;
    private final boolean isGrape;

    public CropBasicGrowthCraft(World world, Block block, int meta, Vect position, boolean isRice, boolean isGrape) {
        super(world, position);
        this.block = block;
        this.meta = meta;
        this.isRice = isRice;
        this.isGrape = isGrape;
    }

    @Override
    protected boolean isCrop(Vect pos) {
        return this.getBlock(pos) == this.block && this.getBlockMeta(pos) == this.meta;
    }

    @Override
    protected Collection<ItemStack> harvestBlock(Vect pos) {
        ArrayList harvest = this.block.getDrops(this.world, pos.x, pos.y, pos.z, this.meta, 0);
        if (harvest.size() > 1) {
            harvest.remove(0);
        }
        Proxies.common.addBlockDestroyEffects(this.world, pos.x, pos.y, pos.z, this.block, 0);
        if (this.isGrape) {
            this.world.setBlockToAir(pos.x, pos.y, pos.z);
        } else {
            this.world.setBlockMetadataWithNotify(pos.x, pos.y, pos.z, 0, 2);
        }
        if (this.isRice) {
            this.world.setBlockMetadataWithNotify(pos.x, pos.y - 1, pos.z, 7, 2);
        }
        return harvest;
    }

    public String toString() {
        return String.format("CropBasicGrowthCraft [ position: [ %s ]; block: %s; meta: %s ]", this.position.toString(), this.block.getUnlocalizedName(), this.meta);
    }
}

