/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.GeneratorFuel;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.interfaces.IRenderableMachine;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.Utils;
import forestry.plugins.PluginIC2;
import ic2.api.energy.prefab.BasicSource;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class MachineGenerator
extends TileBase
implements ISidedInventory,
ILiquidTankContainer,
IRenderableMachine {
    private static final int maxEnergy = 30000;
    public static final short SLOT_CAN = 0;
    private final TankManager tankManager;
    private final FilteredTank resourceTank;
    private int tickCount = 0;
    private BasicSource ic2EnergySource;

    public MachineGenerator() {
        this.setHints(Config.hints.get("generator"));
        this.setInternalInventory(new GeneratorInventoryAdapter(this));
        this.resourceTank = new FilteredTank(10000, FuelManager.generatorFuel.keySet());
        this.tankManager = new TankManager(this.resourceTank);
        if (PluginIC2.instance.isAvailable()) {
            this.ic2EnergySource = new BasicSource((TileEntity)this, 30000.0, 1);
        }
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.GeneratorGUI.ordinal(), player.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (this.ic2EnergySource != null) {
            this.ic2EnergySource.writeToNBT(nbttagcompound);
        }
        this.tankManager.writeTanksToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (this.ic2EnergySource != null) {
            this.ic2EnergySource.readFromNBT(nbttagcompound);
        }
        this.tankManager.readTanksFromNBT(nbttagcompound);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writePacketData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readPacketData(data);
    }

    public void onChunkUnload() {
        if (this.ic2EnergySource != null) {
            this.ic2EnergySource.onChunkUnload();
        }
        super.onChunkUnload();
    }

    @Override
    public void invalidate() {
        if (this.ic2EnergySource != null) {
            this.ic2EnergySource.invalidate();
        }
        super.invalidate();
    }

    @Override
    public void updateServerSide() {
        IErrorLogic errorLogic;
        IInventoryAdapter inventory;
        if (this.updateOnInterval(20) && (inventory = this.getInternalInventory()).getStackInSlot(0) != null) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)inventory, 0);
        }
        if ((errorLogic = this.getErrorLogic()).setCondition(this.ic2EnergySource == null, EnumErrorCode.NOENERGYNET)) {
            return;
        }
        this.ic2EnergySource.updateEntity();
        if (this.resourceTank.getFluidAmount() > 0) {
            GeneratorFuel fuel = FuelManager.generatorFuel.get(this.resourceTank.getFluid().getFluid());
            if (this.resourceTank.getFluidAmount() >= fuel.fuelConsumed.amount && this.ic2EnergySource.getFreeCapacity() >= (double)fuel.eu) {
                this.ic2EnergySource.addEnergy((double)fuel.eu);
                ++this.tickCount;
                if (this.tickCount >= fuel.rate) {
                    this.tickCount = 0;
                    this.resourceTank.drain(fuel.fuelConsumed.amount, true);
                }
            }
        }
        boolean hasFuel = this.resourceTank.getFluidAmount() > 0;
        errorLogic.setCondition(!hasFuel, EnumErrorCode.NOFUEL);
    }

    public boolean isWorking() {
        return this.resourceTank.getFluidAmount() > 0;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.getFluidAmount() * i / 10000;
    }

    public int getStoredScaled(int i) {
        if (this.ic2EnergySource == null) {
            return 0;
        }
        return (int)(this.ic2EnergySource.getEnergyStored() * (double)i) / 30000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return EnumTankLevel.EMPTY;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        int firstMessageId = this.tankManager.maxMessageId() + 1;
        if (i == firstMessageId && this.ic2EnergySource != null) {
            this.ic2EnergySource.setEnergyStored((double)j);
        }
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int firstMessageId = this.tankManager.maxMessageId() + 1;
        if (this.ic2EnergySource != null) {
            iCrafting.sendProgressBarUpdate(container, firstMessageId, (int)((short)this.ic2EnergySource.getEnergyStored()));
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    private static class GeneratorInventoryAdapter
    extends TileInventoryAdapter<MachineGenerator> {
        public GeneratorInventoryAdapter(MachineGenerator generator) {
            super(generator, 1, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 0) {
                Fluid fluid = FluidHelper.getFluidInContainer(itemStack);
                return ((MachineGenerator)this.tile).tankManager.accepts(fluid);
            }
            return false;
        }
    }
}

