/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.common.registry.EntityRegistry;
import forestry.api.core.ForestryAPI;
import forestry.core.circuits.ISocketable;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumTankLevel;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public abstract class Utils {
    private static final int slabWoodId = OreDictionary.getOreID((String)"slabWood");
    private static final Random rand = new Random();

    public static int getUID() {
        return rand.nextInt();
    }

    public static void dropInventory(IInventory inventory, World world, int x, int y, int z) {
        if (inventory == null) {
            return;
        }
        for (int slot = 0; slot < inventory.getSizeInventory(); ++slot) {
            ItemStack itemstack = inventory.getStackInSlot(slot);
            Utils.dropItemStackFromInventory(itemstack, world, x, y, z);
            inventory.setInventorySlotContents(slot, null);
        }
    }

    public static void dropSockets(ISocketable socketable, World world, int x, int y, int z) {
        for (int slot = 0; slot < socketable.getSocketCount(); ++slot) {
            ItemStack itemstack = socketable.getSocket(slot);
            Utils.dropItemStackFromInventory(itemstack, world, x, y, z);
            socketable.setSocket(slot, null);
        }
    }

    public static void dropItemStackFromInventory(ItemStack itemStack, World world, int x, int y, int z) {
        if (itemStack == null) {
            return;
        }
        float f = world.rand.nextFloat() * 0.8f + 0.1f;
        float f1 = world.rand.nextFloat() * 0.8f + 0.1f;
        float f2 = world.rand.nextFloat() * 0.8f + 0.1f;
        while (itemStack.stackSize > 0) {
            int stackPartial = world.rand.nextInt(21) + 10;
            if (stackPartial > itemStack.stackSize) {
                stackPartial = itemStack.stackSize;
            }
            ItemStack drop = itemStack.splitStack(stackPartial);
            EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), drop);
            float accel = 0.05f;
            entityitem.motionX = (float)world.rand.nextGaussian() * accel;
            entityitem.motionY = (float)world.rand.nextGaussian() * accel + 0.2f;
            entityitem.motionZ = (float)world.rand.nextGaussian() * accel;
            world.spawnEntityInWorld((Entity)entityitem);
        }
    }

    public static boolean canWrench(EntityPlayer player, int x, int y, int z) {
        ItemStack itemstack = player.getCurrentEquippedItem();
        if (itemstack == null) {
            return false;
        }
        if (!(itemstack.getItem() instanceof IToolWrench)) {
            return false;
        }
        IToolWrench wrench = (IToolWrench)itemstack.getItem();
        return wrench.canWrench(player, x, y, z);
    }

    public static void useWrench(EntityPlayer player, int x, int y, int z) {
        ItemStack itemstack = player.getCurrentEquippedItem();
        if (itemstack == null) {
            return;
        }
        if (!(itemstack.getItem() instanceof IToolWrench)) {
            return;
        }
        ((IToolWrench)itemstack.getItem()).wrenchUsed(player, x, y, z);
    }

    public static EnumTankLevel rateTankLevel(int scaled) {
        if (scaled < 5) {
            return EnumTankLevel.EMPTY;
        }
        if (scaled < 30) {
            return EnumTankLevel.LOW;
        }
        if (scaled < 60) {
            return EnumTankLevel.MEDIUM;
        }
        if (scaled < 90) {
            return EnumTankLevel.HIGH;
        }
        return EnumTankLevel.MAXIMUM;
    }

    public static boolean isWoodSlabBlock(Block block) {
        int[] oreIds;
        for (int oreId : oreIds = OreDictionary.getOreIDs((ItemStack)new ItemStack(block))) {
            if (oreId != slabWoodId) continue;
            return true;
        }
        return false;
    }

    public static boolean isReplaceableBlock(World world, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        return Utils.isReplaceableBlock(block);
    }

    public static boolean isReplaceableBlock(Block block) {
        return block == Blocks.vine || block == Blocks.tallgrass || block == Blocks.deadbush || block == Blocks.snow_layer || block.getMaterial().isReplaceable();
    }

    public static boolean isUseableByPlayer(EntityPlayer player, TileEntity tile) {
        int x = tile.xCoord;
        int y = tile.yCoord;
        int z = tile.zCoord;
        World world = tile.getWorldObj();
        if (tile.isInvalid()) {
            return false;
        }
        if (world.getTileEntity(x, y, z) != tile) {
            return false;
        }
        return player.getDistanceSq((double)x + 0.5, (double)y + 0.5, (double)z + 0.5) <= 64.0;
    }

    private static <E extends EntityLiving> E createEntity(World world, Class<E> entityClass) {
        if (!EntityList.classToStringMapping.containsKey(entityClass)) {
            return null;
        }
        String entityString = (String)EntityList.classToStringMapping.get(entityClass);
        if (entityString == null) {
            return null;
        }
        Entity entity = EntityList.createEntityByName((String)entityString, (World)world);
        return (E)((EntityLiving)entityClass.cast(entity));
    }

    public static <E extends EntityLiving> E spawnEntity(World world, Class<E> entityClass, double x, double y, double z) {
        E entityLiving = Utils.createEntity(world, entityClass);
        if (entityLiving == null) {
            return null;
        }
        return Utils.spawnEntity(world, entityLiving, x, y, z);
    }

    public static <E extends EntityLiving> E spawnEntity(World world, E living, double x, double y, double z) {
        if (living == null) {
            return null;
        }
        living.setLocationAndAngles(x, y, z, MathHelper.wrapAngleTo180_float((float)(world.rand.nextFloat() * 360.0f)), 0.0f);
        living.rotationYawHead = living.rotationYaw;
        living.renderYawOffset = living.rotationYaw;
        living.onSpawnWithEgg(null);
        world.spawnEntityInWorld(living);
        living.playLivingSound();
        return living;
    }

    public static void registerEntity(Class<? extends Entity> entityClass, String ident, int id, int eggForeground, int eggBackground, int trackingRange, int updateFrequency, boolean sendVelocity) {
        EntityRegistry.registerModEntity(entityClass, (String)ident, (int)id, (Object)ForestryAPI.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendVelocity);
        Proxies.log.finer("Registered entity %s (%s) with id %s.", ident, entityClass.toString(), id);
    }

    public static <T extends TileEntity> T getTile(IBlockAccess world, int x, int y, int z, Class<T> tileClass) {
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (tileClass.isInstance(tileEntity)) {
            return (T)((TileEntity)tileClass.cast(tileEntity));
        }
        Proxies.log.warning("Failed to cast a tile entity {" + tileEntity + "} to a {" + tileClass.getName() + "} at " + x + '/' + y + '/' + z);
        return null;
    }

    public static boolean isIndexInRange(int index, int start, int count) {
        return index >= start && index < start + count;
    }

    public static int addRGBComponents(int colour, int r, int g, int b) {
        r = ((colour & 0xFF0000) >> 16) + r;
        g = ((colour & 0xFF00) >> 8) + g;
        b = (colour & 0xFF) + b;
        r = r <= 255 ? r : 255;
        g = g <= 255 ? g : 255;
        b = b <= 255 ? b : 255;
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int multiplyRGBComponents(int colour, float factor) {
        int r = (int)((float)((colour & 0xFF0000) >> 16) * factor);
        int g = (int)((float)((colour & 0xFF00) >> 8) * factor);
        int b = (int)((float)(colour & 0xFF) * factor);
        r = r <= 255 ? r : 255;
        g = g <= 255 ? g : 255;
        b = b <= 255 ? b : 255;
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }
}

