/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.core.gadgets.TileNaturalistChest;
import forestry.core.interfaces.IBlockRenderer;
import forestry.core.utils.ForestryResource;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderNaturalistChest
extends TileEntitySpecialRenderer
implements IBlockRenderer {
    private final ModelChest chestModel = new ModelChest();
    private final ResourceLocation texture;

    public RenderNaturalistChest(String textureName) {
        this.texture = new ForestryResource("textures/blocks/" + textureName + ".png");
    }

    @Override
    public void inventoryRender(double x, double y, double z) {
        this.render(ForgeDirection.EAST, 0.0f, 0.0f, x, y, z, 0.0f);
    }

    public void renderTileEntityAt(TileEntity tileentity, double x, double y, double z, float partialTick) {
        TileNaturalistChest chest = (TileNaturalistChest)tileentity;
        this.render(chest.getOrientation(), chest.prevLidAngle, chest.lidAngle, x, y, z, partialTick);
    }

    public void render(ForgeDirection orientation, float prevLidAngle, float lidAngle, double x, double y, double z, float partialTick) {
        int rotation;
        GL11.glPushMatrix();
        this.bindTexture(this.texture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        switch (orientation) {
            case EAST: {
                rotation = -90;
                break;
            }
            case NORTH: {
                rotation = 180;
                break;
            }
            case WEST: {
                rotation = 90;
                break;
            }
            default: {
                rotation = 0;
            }
        }
        GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float angle = prevLidAngle + (lidAngle - prevLidAngle) * partialTick;
        angle = 1.0f - angle;
        angle = 1.0f - angle * angle * angle;
        this.chestModel.chestLid.rotateAngleX = -(angle * (float)Math.PI / 2.0f);
        this.chestModel.renderAll();
        GL11.glPopMatrix();
    }
}

