/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.core.interfaces.IBlockRenderer;
import forestry.core.interfaces.IRenderableMachine;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.ForestryResource;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderMachine
extends TileEntitySpecialRenderer
implements IBlockRenderer {
    private final ModelBase model = new ModelBase(){};
    private final ModelRenderer basefront = new ModelRenderer(this.model, 0, 0);
    private final ModelRenderer baseback;
    private final ModelRenderer resourceTank;
    private final ModelRenderer productTank;
    private ResourceLocation[] textures;

    private RenderMachine() {
        this.basefront.addBox(-8.0f, -8.0f, -8.0f, 16, 4, 16);
        this.basefront.rotationPointX = 8.0f;
        this.basefront.rotationPointY = 8.0f;
        this.basefront.rotationPointZ = 8.0f;
        this.baseback = new ModelRenderer(this.model, 0, 0);
        this.baseback.addBox(-8.0f, 4.0f, -8.0f, 16, 4, 16);
        this.baseback.rotationPointX = 8.0f;
        this.baseback.rotationPointY = 8.0f;
        this.baseback.rotationPointZ = 8.0f;
        this.resourceTank = new ModelRenderer(this.model, 0, 0);
        this.resourceTank.addBox(-6.0f, -8.0f, -6.0f, 12, 16, 6);
        this.resourceTank.rotationPointX = 8.0f;
        this.resourceTank.rotationPointY = 8.0f;
        this.resourceTank.rotationPointZ = 8.0f;
        this.productTank = new ModelRenderer(this.model, 0, 0);
        this.productTank.addBox(-6.0f, -8.0f, 0.0f, 12, 16, 6);
        this.productTank.rotationPointX = 8.0f;
        this.productTank.rotationPointY = 8.0f;
        this.productTank.rotationPointZ = 8.0f;
    }

    public RenderMachine(String baseTexture) {
        this();
        this.textures = new ResourceLocation[]{new ForestryResource(baseTexture + "base.png"), new ForestryResource(baseTexture + "tank_resource_empty.png"), new ForestryResource(baseTexture + "tank_resource_low.png"), new ForestryResource(baseTexture + "tank_resource_medium.png"), new ForestryResource(baseTexture + "tank_resource_high.png"), new ForestryResource(baseTexture + "tank_resource_maximum.png"), new ForestryResource(baseTexture + "tank_product_empty.png"), new ForestryResource(baseTexture + "tank_product_low.png"), new ForestryResource(baseTexture + "tank_product_medium.png"), new ForestryResource(baseTexture + "tank_product_high.png"), new ForestryResource(baseTexture + "tank_product_maximum.png")};
    }

    @Override
    public void inventoryRender(double x, double y, double z) {
        this.render(EnumTankLevel.EMPTY, EnumTankLevel.EMPTY, ForgeDirection.UP, x, y, z);
    }

    public void renderTileEntityAt(TileEntity tileentity, double d, double d1, double d2, float f) {
        IRenderableMachine generator = (IRenderableMachine)tileentity;
        this.render(generator.getPrimaryLevel(), generator.getSecondaryLevel(), generator.getOrientation(), d, d1, d2);
    }

    private void render(EnumTankLevel waterLevel, EnumTankLevel melangeLevel, ForgeDirection orientation, double x, double y, double z) {
        this.render(waterLevel.ordinal(), melangeLevel.ordinal(), orientation, x, y, z);
    }

    private void render(int waterLevelInt, int melangeLevelInt, ForgeDirection orientation, double x, double y, double z) {
        ResourceLocation texture;
        EnumTankLevel waterLevel = EnumTankLevel.values()[waterLevelInt];
        EnumTankLevel melangeLevel = EnumTankLevel.values()[melangeLevelInt];
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float[] angle = new float[]{0.0f, 0.0f, 0.0f};
        if (orientation == null) {
            orientation = ForgeDirection.WEST;
        }
        switch (orientation) {
            case EAST: {
                angle[1] = (float)Math.PI;
                angle[2] = -1.5707964f;
                break;
            }
            case WEST: {
                angle[2] = 1.5707964f;
                break;
            }
            case UP: {
                break;
            }
            case DOWN: {
                angle[2] = (float)Math.PI;
                break;
            }
            case SOUTH: {
                angle[0] = 1.5707964f;
                angle[2] = 1.5707964f;
                break;
            }
            default: {
                angle[0] = -1.5707964f;
                angle[2] = 1.5707964f;
            }
        }
        this.basefront.rotateAngleX = angle[0];
        this.basefront.rotateAngleY = angle[1];
        this.basefront.rotateAngleZ = angle[2];
        this.baseback.rotateAngleX = angle[0];
        this.baseback.rotateAngleY = angle[1];
        this.baseback.rotateAngleZ = angle[2];
        this.resourceTank.rotateAngleX = angle[0];
        this.resourceTank.rotateAngleY = angle[1];
        this.resourceTank.rotateAngleZ = angle[2];
        this.productTank.rotateAngleX = angle[0];
        this.productTank.rotateAngleY = angle[1];
        this.productTank.rotateAngleZ = angle[2];
        float factor = 0.0625f;
        Proxies.common.bindTexture(this.textures[Textures.BASE.ordinal()]);
        this.basefront.render(factor);
        Proxies.common.bindTexture(this.textures[Textures.BASE.ordinal()]);
        this.baseback.render(factor);
        switch (waterLevel) {
            case LOW: {
                texture = this.textures[Textures.TANK_R_LOW.ordinal()];
                break;
            }
            case MEDIUM: {
                texture = this.textures[Textures.TANK_R_MEDIUM.ordinal()];
                break;
            }
            case HIGH: {
                texture = this.textures[Textures.TANK_R_HIGH.ordinal()];
                break;
            }
            case MAXIMUM: {
                texture = this.textures[Textures.TANK_R_MAXIMUM.ordinal()];
                break;
            }
            default: {
                texture = this.textures[Textures.TANK_R_EMPTY.ordinal()];
            }
        }
        Proxies.common.bindTexture(texture);
        this.resourceTank.render(factor);
        switch (melangeLevel) {
            case LOW: {
                texture = this.textures[Textures.TANK_P_LOW.ordinal()];
                break;
            }
            case MEDIUM: {
                texture = this.textures[Textures.TANK_P_MEDIUM.ordinal()];
                break;
            }
            case HIGH: {
                texture = this.textures[Textures.TANK_P_HIGH.ordinal()];
                break;
            }
            case MAXIMUM: {
                texture = this.textures[Textures.TANK_P_MAXIMUM.ordinal()];
                break;
            }
            default: {
                texture = this.textures[Textures.TANK_P_EMPTY.ordinal()];
            }
        }
        Proxies.common.bindTexture(texture);
        this.productTank.render(factor);
        GL11.glPopMatrix();
    }

    private static enum Textures {
        BASE,
        TANK_R_EMPTY,
        TANK_R_LOW,
        TANK_R_MEDIUM,
        TANK_R_HIGH,
        TANK_R_MAXIMUM,
        TANK_P_EMPTY,
        TANK_P_LOW,
        TANK_P_MEDIUM,
        TANK_P_HIGH,
        TANK_P_MAXIMUM;

    }
}

