/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.proxy;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.API;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.common.versioning.VersionRange;
import forestry.Forestry;
import forestry.core.TickHandlerCoreServer;
import forestry.core.WorldGenerator;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.multiblock.MultiblockServerTickHandler;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketFXSignal;
import forestry.core.network.PacketId;
import forestry.core.proxy.Proxies;
import forestry.core.render.SpriteSheet;
import forestry.core.utils.StringUtil;
import forestry.plugins.PluginManager;
import java.io.File;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ProxyCommon {
    public String getMinecraftVersion() {
        return Loader.instance().getMinecraftModContainer().getVersion();
    }

    public void registerTickHandlers(WorldGenerator worldGenerator) {
        TickHandlerCoreServer tickHandlerCoreServer = new TickHandlerCoreServer(worldGenerator);
        FMLCommonHandler.instance().bus().register((Object)tickHandlerCoreServer);
        MinecraftForge.EVENT_BUS.register((Object)tickHandlerCoreServer);
        FMLCommonHandler.instance().bus().register((Object)new MultiblockServerTickHandler());
    }

    public void registerBlock(Block block, Class<? extends ItemBlock> itemClass) {
        if (!EnumSet.of(PluginManager.Stage.PRE_INIT).contains((Object)PluginManager.getStage())) {
            throw new RuntimeException("Tried to register Block outside of Pre-Init");
        }
        GameRegistry.registerBlock((Block)block, itemClass, (String)StringUtil.cleanBlockName(block));
    }

    public void registerItem(Item item) {
        GameRegistry.registerItem((Item)item, (String)StringUtil.cleanItemName(item));
    }

    public void addPriorityRecipe(IRecipe recipe) {
        CraftingManager.getInstance().getRecipeList().add(0, recipe);
    }

    public void addPriorityRecipe(ItemStack itemstack, Object ... obj) {
        this.cleanRecipe(obj);
        this.addPriorityRecipe((IRecipe)new ShapedOreRecipe(itemstack, obj));
    }

    public void addPriorityShapelessRecipe(ItemStack itemstack, Object ... obj) {
        this.cleanRecipe(obj);
        this.addPriorityRecipe((IRecipe)new ShapelessOreRecipe(itemstack, obj));
    }

    public void addRecipe(ItemStack itemstack, Object ... obj) {
        this.cleanRecipe(obj);
        CraftingManager.getInstance().getRecipeList().add(new ShapedOreRecipe(itemstack, obj));
    }

    public void addShapelessRecipe(ItemStack itemstack, Object ... obj) {
        this.cleanRecipe(obj);
        CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(itemstack, obj));
    }

    private void cleanRecipe(Object ... obj) {
        for (int i = 0; i < obj.length; ++i) {
            if (obj[i] instanceof ForestryItem) {
                obj[i] = ((ForestryItem)((Object)obj[i])).item();
                continue;
            }
            if (!(obj[i] instanceof ForestryBlock)) continue;
            obj[i] = ((ForestryBlock)((Object)obj[i])).block();
        }
    }

    public void addSmelting(ItemStack res, ItemStack prod) {
        this.addSmelting(res, prod, 0.0f);
    }

    public void addSmelting(ItemStack res, ItemStack prod, float xp) {
        if (res == null || res.getItem() == null) {
            throw new IllegalArgumentException("Tried to register smelting recipe with null input");
        }
        if (prod == null || prod.getItem() == null) {
            throw new IllegalArgumentException("Tried to register smelting recipe with null output");
        }
        GameRegistry.addSmelting((ItemStack)res, (ItemStack)prod, (float)xp);
    }

    public void dropItemPlayer(EntityPlayer player, ItemStack stack) {
        player.dropPlayerItemWithRandomChoice(stack, true);
    }

    public void setHabitatLocatorCoordinates(Entity player, ChunkCoordinates coordinates) {
        if (coordinates != null) {
            Forestry.packetHandler.sendPacket(new PacketCoordinates(PacketId.HABITAT_BIOME_POINTER, coordinates).getPacket(), (EntityPlayerMP)player);
        }
    }

    public void removePotionEffect(EntityPlayer player, Potion effect) {
        player.clearActivePotions();
    }

    public String getCurrentLanguage() {
        return null;
    }

    public String getItemStackDisplayName(Item item) {
        return null;
    }

    public String getDisplayName(ItemStack itemstack) {
        return null;
    }

    public File getForestryRoot() {
        return new File(".");
    }

    public int getByBlockModelId() {
        return 0;
    }

    public boolean isOp(EntityPlayer player) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        return server.getConfigurationManager().func_152596_g(player.getGameProfile());
    }

    public double getBlockReachDistance(EntityPlayer entityplayer) {
        return 4.0;
    }

    public boolean isSimulating(World world) {
        return true;
    }

    public boolean isShiftDown() {
        return false;
    }

    public boolean isItemStackTagEqual(ItemStack stack1, ItemStack stack2) {
        return ItemStack.areItemStackTagsEqual((ItemStack)stack1, (ItemStack)stack2);
    }

    public String getItemStackDisplayName(ItemStack stack) {
        return null;
    }

    public boolean setBlockWithNotify(World world, int x, int y, int z, Block block) {
        return world.setBlock(x, y, z, block, 0, 3);
    }

    public void playSoundFX(World world, int x, int y, int z, Block block) {
        Proxies.net.sendNetworkPacket(new PacketFXSignal(PacketFXSignal.SoundFXType.LEAF, x, y, z, block, 0), world);
    }

    public void playSoundFX(World world, int x, int y, int z, String sound, float volume, float pitch) {
    }

    public void addEntitySwarmFX(World world, double d1, double d2, double d3) {
    }

    public void addEntityExplodeFX(World world, double d1, double d2, double d3) {
    }

    public void addEntitySnowFX(World world, double d1, double d2, double d3) {
    }

    public void addEntityIgnitionFX(World world, double d1, double d2, double d3) {
    }

    public void addEntityPotionFX(World world, double d1, double d2, double d3, int color) {
    }

    public void addBlockDestroyEffects(World world, int xCoord, int yCoord, int zCoord, Block block, int i) {
        this.sendFXSignal(PacketFXSignal.VisualFXType.BLOCK_DESTROY, PacketFXSignal.SoundFXType.BLOCK_DESTROY, world, xCoord, yCoord, zCoord, block, i);
    }

    public void addBlockPlaceEffects(World world, int xCoord, int yCoord, int zCoord, Block block, int i) {
        this.sendFXSignal(PacketFXSignal.VisualFXType.NONE, PacketFXSignal.SoundFXType.BLOCK_PLACE, world, xCoord, yCoord, zCoord, block, i);
    }

    public void playBlockBreakSoundFX(World world, int x, int y, int z, Block block) {
    }

    public void playBlockPlaceSoundFX(World world, int x, int y, int z, Block block) {
    }

    public void sendFXSignal(PacketFXSignal.VisualFXType visualFX, PacketFXSignal.SoundFXType soundFX, World world, int xCoord, int yCoord, int zCoord, Block block, int i) {
        if (Proxies.common.isSimulating(world)) {
            Proxies.net.sendNetworkPacket(new PacketFXSignal(visualFX, soundFX, xCoord, yCoord, zCoord, block, i), world);
        }
    }

    public IResourceManager getSelectedTexturePack(Minecraft minecraft) {
        return null;
    }

    public World getRenderWorld() {
        return null;
    }

    public Minecraft getClientInstance() {
        return FMLClientHandler.instance().getClient();
    }

    public boolean isModLoaded(String modname) {
        return Loader.isModLoaded((String)modname);
    }

    public boolean isModLoaded(String modname, String versionRangeString) {
        if (!this.isModLoaded(modname)) {
            return false;
        }
        if (versionRangeString != null) {
            ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(modname);
            ArtifactVersion modVersion = mod.getProcessedVersion();
            VersionRange versionRange = VersionParser.parseRange((String)versionRangeString);
            DefaultArtifactVersion requiredVersion = new DefaultArtifactVersion(modname, versionRange);
            if (!requiredVersion.containsVersion(modVersion)) {
                return false;
            }
        }
        return true;
    }

    public boolean isAPILoaded(String apiName) {
        return this.isAPILoaded(apiName, null);
    }

    public boolean isAPILoaded(String apiName, String versionRangeString) {
        Package apiPackage = Package.getPackage(apiName);
        if (apiPackage == null) {
            return false;
        }
        API apiAnnotation = apiPackage.getAnnotation(API.class);
        if (apiAnnotation == null) {
            return false;
        }
        if (versionRangeString != null) {
            DefaultArtifactVersion givenVersion;
            String apiVersionString = apiAnnotation.apiVersion();
            if (apiVersionString == null) {
                return false;
            }
            VersionRange versionRange = VersionParser.parseRange((String)versionRangeString);
            DefaultArtifactVersion requiredVersion = new DefaultArtifactVersion(apiName, versionRange);
            if (!requiredVersion.containsVersion((ArtifactVersion)(givenVersion = new DefaultArtifactVersion(apiName, apiVersionString)))) {
                return false;
            }
        }
        return true;
    }

    public Object instantiateIfModLoaded(String modname, String className) {
        return this.instantiateIfModLoaded(modname, null, className);
    }

    public Object instantiateIfModLoaded(String modname, String versionRangeString, String className) {
        if (this.isModLoaded(modname, versionRangeString)) {
            try {
                Class<?> clas = Class.forName(className, true, Loader.instance().getModClassLoader());
                return clas.newInstance();
            }
            catch (Exception ex) {
                Proxies.log.severe("Failed to load " + className + " even though mod " + modname + " was available.");
                return null;
            }
        }
        return null;
    }

    public void bindTexture(ResourceLocation location) {
    }

    public void bindTexture(SpriteSheet spriteSheet) {
    }

    public EntityPlayer getPlayer() {
        return null;
    }

    public EntityPlayer getPlayer(World world, GameProfile profile) {
        if (world == null) {
            throw new IllegalArgumentException("World cannot be null");
        }
        if (profile == null || profile.getName() == null) {
            return FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world));
        }
        EntityPlayer player = world.getPlayerEntityByName(profile.getName());
        if (player != null) {
            return player;
        }
        return FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)profile);
    }
}

