/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.proxy;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import forestry.apiculture.render.TextureHabitatLocator;
import forestry.core.ForestryClient;
import forestry.core.TickHandlerCoreClient;
import forestry.core.WorldGenerator;
import forestry.core.multiblock.MultiblockClientTickHandler;
import forestry.core.proxy.ClientProxyRender;
import forestry.core.proxy.Proxies;
import forestry.core.proxy.ProxyCommon;
import forestry.core.render.EntityHoneydustFX;
import forestry.core.render.EntityIgnitionFX;
import forestry.core.render.EntitySnowFX;
import forestry.core.render.SpriteSheet;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.EntityExplodeFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntitySpellParticleFX;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ClientProxyCommon
extends ProxyCommon {
    @Override
    public void bindTexture(ResourceLocation location) {
        this.getClientInstance().getTextureManager().bindTexture(location);
    }

    @Override
    public void bindTexture(SpriteSheet spriteSheet) {
        this.bindTexture(spriteSheet.getLocation());
    }

    @Override
    public void registerTickHandlers(WorldGenerator worldGenerator) {
        super.registerTickHandlers(worldGenerator);
        FMLCommonHandler.instance().bus().register((Object)new TickHandlerCoreClient());
        FMLCommonHandler.instance().bus().register((Object)new MultiblockClientTickHandler());
    }

    @Override
    public IResourceManager getSelectedTexturePack(Minecraft minecraft) {
        return minecraft.getResourceManager();
    }

    @Override
    public void setHabitatLocatorCoordinates(Entity player, ChunkCoordinates coordinates) {
        TextureHabitatLocator.getInstance().setTargetCoordinates(coordinates);
    }

    @Override
    public File getForestryRoot() {
        return Minecraft.getMinecraft().mcDataDir;
    }

    @Override
    public World getRenderWorld() {
        return this.getClientInstance().theWorld;
    }

    @Override
    public int getByBlockModelId() {
        return ForestryClient.byBlockModelId;
    }

    @Override
    public boolean isOp(EntityPlayer player) {
        return false;
    }

    @Override
    public double getBlockReachDistance(EntityPlayer entityplayer) {
        if (entityplayer instanceof EntityPlayerSP) {
            return this.getClientInstance().playerController.getBlockReachDistance();
        }
        return 4.0;
    }

    @Override
    public boolean isSimulating(World world) {
        return !world.isRemote;
    }

    @Override
    public boolean isShiftDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    @Override
    public String getItemStackDisplayName(Item item) {
        return item.getItemStackDisplayName(null);
    }

    @Override
    public String getItemStackDisplayName(ItemStack stack) {
        return stack.getItem().getItemStackDisplayName(stack);
    }

    @Override
    public String getCurrentLanguage() {
        return Minecraft.getMinecraft().getLanguageManager().getCurrentLanguage().getLanguageCode();
    }

    @Override
    public String getDisplayName(ItemStack itemstack) {
        return itemstack.getItem().getItemStackDisplayName(itemstack);
    }

    @Override
    public void playSoundFX(World world, int x, int y, int z, Block block) {
        if (Proxies.common.isSimulating(world)) {
            super.playSoundFX(world, x, y, z, block);
        } else {
            this.playSoundFX(world, x, y, z, block.stepSound.getStepResourcePath(), block.stepSound.getVolume(), block.stepSound.getPitch());
        }
    }

    @Override
    public void playBlockBreakSoundFX(World world, int x, int y, int z, Block block) {
        if (Proxies.common.isSimulating(world)) {
            super.playSoundFX(world, x, y, z, block);
        } else {
            this.playSoundFX(world, x, y, z, block.stepSound.getBreakSound(), block.stepSound.getVolume() / 4.0f, block.stepSound.getPitch());
        }
    }

    @Override
    public void playBlockPlaceSoundFX(World world, int x, int y, int z, Block block) {
        if (Proxies.common.isSimulating(world)) {
            super.playSoundFX(world, x, y, z, block);
        } else {
            this.playSoundFX(world, x, y, z, block.stepSound.getStepResourcePath(), block.stepSound.getVolume() / 4.0f, block.stepSound.getPitch());
        }
    }

    @Override
    public void playSoundFX(World world, int x, int y, int z, String sound, float volume, float pitch) {
        world.playSound((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, sound, volume, (1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.2f) * 0.7f, false);
    }

    @Override
    public void addEntitySwarmFX(World world, double d1, double d2, double d3) {
        if (!ClientProxyRender.shouldSpawnParticle(world)) {
            return;
        }
        this.getClientInstance().effectRenderer.addEffect((EntityFX)new EntityHoneydustFX(world, d1, d2, d3, 0.0f, 0.0f, 0.0f));
    }

    @Override
    public void addEntityExplodeFX(World world, double d1, double d2, double d3) {
        if (!ClientProxyRender.shouldSpawnParticle(world)) {
            return;
        }
        this.getClientInstance().effectRenderer.addEffect((EntityFX)new EntityExplodeFX(world, d1, d2, d3, 0.0, 0.0, 0.0));
    }

    @Override
    public void addEntitySnowFX(World world, double d1, double d2, double d3) {
        if (!ClientProxyRender.shouldSpawnParticle(world)) {
            return;
        }
        this.getClientInstance().effectRenderer.addEffect((EntityFX)new EntitySnowFX(world, d1 + world.rand.nextGaussian(), d2, d3 + world.rand.nextGaussian()));
    }

    @Override
    public void addEntityIgnitionFX(World world, double d1, double d2, double d3) {
        if (!ClientProxyRender.shouldSpawnParticle(world)) {
            return;
        }
        this.getClientInstance().effectRenderer.addEffect((EntityFX)new EntityIgnitionFX(world, d1, d2, d3));
    }

    @Override
    public void addEntityPotionFX(World world, double d1, double d2, double d3, int color) {
        if (!ClientProxyRender.shouldSpawnParticle(world)) {
            return;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        EntitySpellParticleFX entityfx = new EntitySpellParticleFX(world, d1, d2, d3, 0.0, 0.0, 0.0);
        entityfx.setRBGColorF(red, green, blue);
        this.getClientInstance().effectRenderer.addEffect((EntityFX)entityfx);
    }

    @Override
    public void addBlockDestroyEffects(World world, int xCoord, int yCoord, int zCoord, Block block, int i) {
        if (!this.isSimulating(world)) {
            this.getClientInstance().effectRenderer.addBlockDestroyEffects(xCoord, yCoord, zCoord, block, i);
        } else {
            super.addBlockDestroyEffects(world, xCoord, yCoord, zCoord, block, i);
        }
    }

    @Override
    public void addBlockPlaceEffects(World world, int xCoord, int yCoord, int zCoord, Block block, int i) {
        if (!this.isSimulating(world)) {
            this.playBlockPlaceSoundFX(world, xCoord, yCoord, zCoord, block);
        } else {
            super.addBlockPlaceEffects(world, xCoord, yCoord, zCoord, block, i);
        }
    }

    @Override
    public EntityPlayer getPlayer() {
        return Minecraft.getMinecraft().thePlayer;
    }

    @Override
    public EntityPlayer getPlayer(World world, GameProfile profile) {
        return super.getPlayer(world, profile);
    }
}

