/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.core.items.ItemForestry;
import forestry.core.proxy.Proxies;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemAssemblyKit
extends ItemForestry {
    private final ItemStack assembled;
    private final boolean motionOnOpen;

    public ItemAssemblyKit(ItemStack assembled) {
        this(assembled, false);
    }

    public ItemAssemblyKit(ItemStack assembled, boolean motionOnOpen) {
        this.maxStackSize = 24;
        this.assembled = assembled;
        this.motionOnOpen = motionOnOpen;
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (Proxies.common.isSimulating(world)) {
            --itemstack.stackSize;
            EntityItem entity = new EntityItem(world, entityplayer.posX, entityplayer.posY, entityplayer.posZ, this.assembled.copy());
            if (this.motionOnOpen) {
                float f1 = 0.3f;
                entity.motionX = -MathHelper.sin((float)(entityplayer.rotationYaw / 180.0f * 3.141593f)) * MathHelper.cos((float)(entityplayer.rotationPitch / 180.0f * 3.141593f)) * f1;
                entity.motionZ = MathHelper.cos((float)(entityplayer.rotationYaw / 180.0f * 3.141593f)) * MathHelper.cos((float)(entityplayer.rotationPitch / 180.0f * 3.141593f)) * f1;
                entity.motionY = -MathHelper.sin((float)(entityplayer.rotationPitch / 180.0f * 3.141593f)) * f1 + 0.1f;
                f1 = 0.02f;
                float f3 = world.rand.nextFloat() * 3.141593f * 2.0f;
                entity.motionX += Math.cos(f3) * (double)(f1 *= world.rand.nextFloat());
                entity.motionY += (double)((world.rand.nextFloat() - world.rand.nextFloat()) * 0.1f);
                entity.motionZ += Math.sin(f3) * (double)f1;
            }
            world.spawnEntityInWorld((Entity)entity);
        }
        return itemstack;
    }
}

