/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.interfaces.IPowerHandler;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import forestry.energy.EnergyManager;

public class PowerLedger
extends Ledger {
    private final IPowerHandler tile;

    public PowerLedger(LedgerManager manager, IPowerHandler tile) {
        super(manager, "power");
        this.tile = tile;
        this.maxHeight = 94;
    }

    @Override
    public void draw(int x, int y) {
        this.drawBackground(x, y);
        this.drawIcon(TextureManager.getInstance().getDefault("misc/energy"), x + 3, y + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        EnergyManager energyManager = this.tile.getEnergyManager();
        this.drawHeader(StringUtil.localize("gui.energy"), x + 22, y + 8);
        this.drawSubheader(StringUtil.localize("gui.stored") + ':', x + 22, y + 20);
        this.drawText(energyManager.getTotalEnergyStored() + " RF", x + 22, y + 32);
        this.drawSubheader(StringUtil.localize("gui.maxenergy") + ':', x + 22, y + 44);
        this.drawText(energyManager.getMaxEnergyStored() + " RF", x + 22, y + 56);
        this.drawSubheader(StringUtil.localize("gui.maxenergyreceive") + ':', x + 22, y + 68);
        this.drawText(energyManager.getMaxEnergyReceived() + " RF", x + 22, y + 80);
    }

    @Override
    public String getTooltip() {
        return this.tile.getEnergyManager().getTotalEnergyStored() + " RF";
    }
}

