/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.interfaces.IHintSource;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class HintLedger
extends Ledger {
    private final String hintString;
    private final String hintTooltip;

    public HintLedger(LedgerManager manager, IHintSource tile) {
        super(manager, "hint");
        String[] hints = tile.getHints();
        int position = new Random().nextInt(hints.length);
        this.hintString = StringUtil.localize("hints." + hints[position] + ".desc");
        this.hintTooltip = StringUtil.localize("hints." + hints[position] + ".tag");
        Minecraft minecraft = Proxies.common.getClientInstance();
        FontRenderer fontRenderer = minecraft.fontRenderer;
        int lineCount = fontRenderer.listFormattedStringToWidth(this.hintString, 96).size();
        this.maxHeight = (lineCount + 1) * fontRenderer.FONT_HEIGHT + 20;
    }

    @Override
    public void draw(int x, int y) {
        this.drawBackground(x, y);
        this.drawIcon(TextureManager.getInstance().getDefault("misc/hint"), x + 3, y + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        this.drawHeader(StringUtil.localize("gui.didyouknow") + '?', x + 22, y + 8);
        this.drawSplitText(this.hintString, x + 22, y + 20, 96);
    }

    @Override
    public String getTooltip() {
        return this.hintTooltip;
    }
}

