/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import forestry.core.gadgets.NaturalistGame;
import forestry.core.gadgets.TileEscritoire;
import forestry.core.gui.ContainerEscritoire;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.network.PacketGuiSelect;
import forestry.core.network.PacketId;
import forestry.core.proxy.Proxies;
import forestry.core.render.SpriteSheet;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import java.util.List;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class GuiEscritoire
extends GuiForestry<ContainerEscritoire, TileEscritoire> {
    private static final ListMultimap<Notes, String> researchNotes = ArrayListMultimap.create();
    private final ItemStack LEVEL_ITEM = new ItemStack(Items.paper);
    private String researchNote = "";
    private long lastUpdate;

    public GuiEscritoire(EntityPlayer player, TileEscritoire tile) {
        super("textures/gui/escritoire.png", new ContainerEscritoire(player, tile), tile);
        this.xSize = 228;
        this.ySize = 235;
        this.widgetManager.add(new ProbeButton(this.widgetManager, 14, 16));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 115, 51, 0));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 115, 77, 1));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 94, 90, 2));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 73, 77, 3));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 73, 51, 4));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 94, 38, 5));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 115, 25, 6));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 136, 38, 7));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 136, 64, 8));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 136, 90, 9));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 115, 103, 10));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 94, 116, 11));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 73, 103, 12));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 52, 90, 13));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 52, 64, 14));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 52, 38, 15));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 73, 25, 16));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 94, 12, 17));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 52, 12, 18));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 136, 12, 19));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 52, 116, 20));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 136, 116, 21));
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(var1, mouseX, mouseY);
        for (int i = 0; i <= ((TileEscritoire)this.inventory).getGame().getBountyLevel() / 4; ++i) {
            RenderHelper.enableGUIStandardItemLighting();
            GuiForestry.itemRender.renderItemAndEffectIntoGUI(this.mc.fontRenderer, this.mc.renderEngine, this.LEVEL_ITEM, this.guiLeft + 170 + i * 8, this.guiTop + 7);
            RenderHelper.disableStandardItemLighting();
        }
        this.startPage();
        GL11.glPushMatrix();
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        GL11.glTranslated((double)(this.guiLeft + 170), (double)(this.guiTop + 10), (double)0.0);
        this.newLine();
        this.newLine();
        String format = EnumChatFormatting.UNDERLINE + EnumChatFormatting.ITALIC.toString();
        this.drawLine(format + "Attempt No. " + (16 - ((TileEscritoire)this.inventory).getGame().getBountyLevel()), 170, this.fontColor.get("gui.mail.lettertext"));
        this.newLine();
        this.drawSplitLine(this.getResearchNote(), 170, 90, this.fontColor.get("gui.mail.lettertext"));
        GL11.glPopMatrix();
        this.endPage();
    }

    private String getResearchNote() {
        int bounty;
        if (this.lastUpdate == ((TileEscritoire)this.inventory).getGame().getLastUpdate()) {
            return this.researchNote;
        }
        this.researchNote = !((TileEscritoire)this.inventory).getGame().isInited() ? StringUtil.localize("gui.escritoire.instructions") : (((TileEscritoire)this.inventory).getGame().isWon() ? this.getRandomNote(researchNotes.get((Object)Notes.success)) : (((TileEscritoire)this.inventory).getGame().isEnded() ? this.getRandomNote(researchNotes.get((Object)Notes.failure)) : ((bounty = ((TileEscritoire)this.inventory).getGame().getBountyLevel()) >= 16 ? this.getRandomNote(researchNotes.get((Object)Notes.level1)) : (bounty > 8 ? this.getRandomNote(researchNotes.get((Object)Notes.level2)) : (bounty > 4 ? this.getRandomNote(researchNotes.get((Object)Notes.level3)) : this.getRandomNote(researchNotes.get((Object)Notes.level4)))))));
        this.lastUpdate = ((TileEscritoire)this.inventory).getGame().getLastUpdate();
        return this.researchNote;
    }

    private String getRandomNote(List<String> candidates) {
        int index = this.mc.theWorld.rand.nextInt(candidates.size());
        return candidates.get(index);
    }

    static {
        for (Notes notesLevel : Notes.values()) {
            int levelCount = Integer.valueOf(StringUtil.localize("gui.escritoire.notes." + (Object)((Object)notesLevel) + ".count"));
            for (int i = 1; i <= levelCount; ++i) {
                String note = StringUtil.localize("gui.escritoire.notes." + (Object)((Object)notesLevel) + '.' + i);
                researchNotes.put((Object)notesLevel, (Object)note);
            }
        }
    }

    private class ProbeButton
    extends Widget {
        private boolean pressed;

        public ProbeButton(WidgetManager manager, int xPos, int yPos) {
            super(manager, xPos, yPos);
            this.width = 22;
            this.height = 25;
        }

        @Override
        public void draw(int startX, int startY) {
            this.manager.gui.bindTexture(this.manager.gui.textureFile);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.manager.gui.drawTexturedModalRect(startX + this.xPos, startY + this.yPos, 228, this.pressed ? 47 : 22, this.width, this.height);
        }

        @Override
        protected String getLegacyTooltip(EntityPlayer player) {
            return StringUtil.localize("gui.escritoire.probe");
        }

        @Override
        public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
            this.pressed = true;
            PacketGuiSelect packet = new PacketGuiSelect(PacketId.GUI_SELECTION_CHANGE, -1, 0);
            Proxies.net.sendToServer(packet);
        }

        @Override
        public void handleMouseRelease(int mouseX, int mouseY, int eventType) {
            if (this.pressed) {
                this.pressed = false;
            }
        }

        @Override
        public void handleMouseMove(int mouseX, int mouseY, int mouseButton, long time) {
            if (GuiEscritoire.this.widgetManager.getAtPosition(mouseX - GuiEscritoire.this.getGuiLeft(), mouseY - GuiEscritoire.this.getGuiTop()) != this) {
                this.pressed = false;
            }
        }
    }

    private class TokenSlot
    extends Widget {
        private final ItemStack HIDDEN_TOKEN;
        private final int index;

        public TokenSlot(WidgetManager manager, int xPos, int yPos, int index) {
            super(manager, xPos, yPos);
            this.index = index;
            this.HIDDEN_TOKEN = new ItemStack(Items.book);
        }

        private boolean hasToken() {
            return ((TileEscritoire)GuiEscritoire.this.inventory).getGame().getToken(this.index) != null;
        }

        private NaturalistGame.GameToken getToken() {
            return ((TileEscritoire)GuiEscritoire.this.inventory).getGame().getToken(this.index);
        }

        @Override
        public void draw(int startX, int startY) {
            if (!this.hasToken()) {
                return;
            }
            int tokenColour = this.getToken().getTokenColour();
            float colorR = (float)(tokenColour >> 16 & 0xFF) / 255.0f;
            float colorG = (float)(tokenColour >> 8 & 0xFF) / 255.0f;
            float colorB = (float)(tokenColour & 0xFF) / 255.0f;
            this.manager.gui.bindTexture(this.manager.gui.textureFile);
            GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
            this.manager.gui.drawTexturedModalRect(startX + this.xPos, startY + this.yPos, 228, 0, 22, 22);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ItemStack tokenStack = this.HIDDEN_TOKEN;
            if (this.getToken().isVisible()) {
                tokenStack = this.getToken().tokenStack;
            }
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)2929);
            RenderHelper.enableGUIStandardItemLighting();
            this.manager.gui.drawItemStack(tokenStack, startX + this.xPos + 3, startY + this.yPos + 3);
            RenderHelper.disableStandardItemLighting();
            GL11.glPopAttrib();
            this.manager.gui.setZLevel(150.0f);
            for (String ident : this.getToken().getOverlayIcons()) {
                RenderHelper.enableGUIStandardItemLighting();
                Proxies.common.bindTexture(SpriteSheet.ITEMS);
                this.manager.gui.drawTexturedModelRectFromIcon(startX + this.xPos + 3, startY + this.yPos + 3, TextureManager.getInstance().getDefault(ident), 16, 16);
                RenderHelper.disableStandardItemLighting();
            }
            this.manager.gui.setZLevel(0.0f);
        }

        @Override
        protected String getLegacyTooltip(EntityPlayer player) {
            return this.hasToken() && this.getToken().isVisible() ? this.getToken().getTooltip() : null;
        }

        @Override
        public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
            PacketGuiSelect packet = new PacketGuiSelect(PacketId.GUI_SELECTION_CHANGE, this.index, 0);
            Proxies.net.sendToServer(packet);
        }
    }

    private static enum Notes {
        level1,
        level2,
        level3,
        level4,
        success,
        failure;

    }
}

