/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.GuiHandler;
import forestry.core.config.Config;
import forestry.core.gadgets.TileBase;
import forestry.core.gui.IPagedInventory;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public abstract class TileNaturalistChest
extends TileBase
implements IPagedInventory {
    private static final float lidAngleVariationPerTick = 0.1f;
    private final int guiID;
    public float lidAngle;
    public float prevLidAngle;
    private int numPlayersUsing;

    public TileNaturalistChest(ISpeciesRoot speciesRoot, int guiId) {
        this.setInternalInventory(new NaturalistInventoryAdapter(this, speciesRoot));
        this.setHints(Config.hints.get("apiarist.chest"));
        this.guiID = guiId;
    }

    @Override
    protected void updateClientSide() {
        this.update();
    }

    @Override
    protected void updateServerSide() {
        this.update();
    }

    private void update() {
        this.prevLidAngle = this.lidAngle;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            this.playLidSound("random.chestopen");
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float oldAngle = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            this.lidAngle = Math.max(Math.min(this.lidAngle, 1.0f), 0.0f);
            if (this.lidAngle < 0.5f && oldAngle >= 0.5f) {
                this.playLidSound("random.chestclosed");
            }
        }
    }

    private void playLidSound(String sound) {
        this.worldObj.playSoundEffect((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, sound, 0.5f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, this.guiID, player.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void flipPage(EntityPlayer player, int page) {
        player.openGui(ForestryAPI.instance, GuiHandler.encodeGuiData(this.guiID, page), player.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeInt(this.numPlayersUsing);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.numPlayersUsing = data.readInt();
    }

    private static class NaturalistInventoryAdapter
    extends TileInventoryAdapter<TileNaturalistChest> {
        private final ISpeciesRoot speciesRoot;

        public NaturalistInventoryAdapter(TileNaturalistChest tile, ISpeciesRoot speciesRoot) {
            super(tile, 125, "Items");
            this.speciesRoot = speciesRoot;
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemstack) {
            return this.speciesRoot.isMember(itemstack);
        }

        @Override
        public boolean canExtractItem(int slotIndex, ItemStack stack, int side) {
            return true;
        }

        @Override
        public void openInventory() {
            ((TileNaturalistChest)this.tile).numPlayersUsing++;
            ((TileNaturalistChest)this.tile).setNeedsNetworkUpdate();
        }

        @Override
        public void closeInventory() {
            ((TileNaturalistChest)this.tile).numPlayersUsing--;
            if (((TileNaturalistChest)this.tile).numPlayersUsing < 0) {
                ((TileNaturalistChest)this.tile).numPlayersUsing = 0;
            }
            ((TileNaturalistChest)this.tile).setNeedsNetworkUpdate();
        }
    }
}

