/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import forestry.core.circuits.ISocketable;
import forestry.core.gadgets.BlockForestry;
import forestry.core.multiblock.MultiblockControllerBase;
import forestry.core.multiblock.MultiblockTileEntityBase;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public abstract class BlockStructure
extends BlockForestry {
    private long previousMessageTick = 0L;

    protected BlockStructure(Material material) {
        super(material);
        this.setHardness(1.0f);
    }

    public boolean canSilkHarvest() {
        return false;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (player.isSneaking()) {
            return false;
        }
        TileEntity tile = world.getTileEntity(x, y, z);
        if (!(tile instanceof MultiblockTileEntityBase)) {
            return false;
        }
        MultiblockTileEntityBase part = (MultiblockTileEntityBase)tile;
        MultiblockControllerBase controller = part.getMultiblockController();
        if (player.getCurrentEquippedItem() == null && !controller.isAssembled()) {
            if (controller != null) {
                MultiblockValidationException e = controller.getLastValidationException();
                if (e != null) {
                    long tick = world.getTotalWorldTime();
                    if (tick > this.previousMessageTick + 20L) {
                        player.addChatMessage((IChatComponent)new ChatComponentText(e.getMessage()));
                        this.previousMessageTick = tick;
                    }
                    return true;
                }
            } else {
                player.addChatMessage((IChatComponent)new ChatComponentText(StatCollector.translateToLocal((String)"for.multiblock.error.notConnected")));
                return true;
            }
        }
        if (controller == null || !controller.isAssembled()) {
            return false;
        }
        if (!world.isRemote) {
            part.openGui(player);
        }
        return true;
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        MultiblockTileEntityBase part;
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof MultiblockTileEntityBase && (part = (MultiblockTileEntityBase)tile).getNeighboringParts().length == 0) {
            Utils.dropInventory((IInventory)part, world, x, y, z);
            if (tile instanceof ISocketable) {
                Utils.dropSockets((ISocketable)tile, tile.getWorldObj(), tile.xCoord, tile.yCoord, tile.zCoord);
            }
        }
        super.breakBlock(world, x, y, z, block, meta);
    }
}

