/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.config.Defaults;
import forestry.core.fluids.Fluids;
import forestry.core.render.EntityColoredDropParticleFX;
import forestry.core.render.TextureManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class BlockForestryFluid
extends BlockFluidClassic {
    private final boolean flammable;
    private final int flammability;
    private final Color color;
    @SideOnly(value=Side.CLIENT)
    private List<IIcon> icons;

    public BlockForestryFluid(Fluids forestryFluid) {
        this(forestryFluid, 0, false);
    }

    public BlockForestryFluid(Fluids forestryFluid, int flammability, boolean flammable) {
        this(forestryFluid.getFluid(), flammability, flammable, forestryFluid.getColor());
    }

    private BlockForestryFluid(Fluid fluid, int flammability, boolean flammable, Color color) {
        super(fluid, Material.water);
        this.setDensity(fluid.getDensity());
        this.flammability = flammability;
        this.flammable = flammable;
        this.color = color;
    }

    public boolean canDrain(World world, int x, int y, int z) {
        return true;
    }

    public Fluid getFluid() {
        return FluidRegistry.getFluid((String)this.fluidName);
    }

    public IIcon getIcon(int side, int meta) {
        if (side == 0 || side == 1 || this.icons.size() == 1) {
            return this.icons.get(0);
        }
        return this.icons.get(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.icons = new ArrayList<IIcon>(2);
        String still = "liquid/" + this.fluidName + "_still";
        this.icons.add(TextureManager.getInstance().registerTex(iconRegister, still));
        if (this.flowTextureExists()) {
            String flow = "liquid/" + this.fluidName + "_flow";
            this.icons.add(TextureManager.getInstance().registerTex(iconRegister, flow));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private boolean flowTextureExists() {
        try {
            ResourceLocation resourceLocation = new ResourceLocation(Defaults.ID, "textures/blocks/liquid/" + this.fluidName + "_flow.png");
            IResourceManager resourceManager = Minecraft.getMinecraft().getResourceManager();
            return resourceManager.getResource(resourceLocation) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        if (rand.nextInt(10) == 0 && World.doesBlockHaveSolidTopSurface((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) && !world.getBlock(x, y - 2, z).getMaterial().blocksMovement()) {
            double px = (float)x + rand.nextFloat();
            double py = (double)y - 1.05;
            double pz = (float)z + rand.nextFloat();
            EntityColoredDropParticleFX fx = new EntityColoredDropParticleFX(world, px, py, pz, this.color.getRed(), this.color.getGreen(), this.color.getBlue());
            FMLClientHandler.instance().getClient().effectRenderer.addEffect((EntityFX)fx);
        }
    }

    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        if (world.getBlock(x, y, z).getMaterial().isLiquid()) {
            return false;
        }
        return super.canDisplace(world, x, y, z);
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        if (world.getBlock(x, y, z).getMaterial().isLiquid()) {
            return false;
        }
        return super.displaceIfPossible(world, x, y, z);
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.flammable ? 30 : 0;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.flammability;
    }

    private static boolean isFlammable(IBlockAccess world, int x, int y, int z) {
        return world.getBlock(x, y, z).isFlammable(world, x, y, z, ForgeDirection.UNKNOWN);
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.flammable;
    }

    public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
        return this.flammable && this.flammability == 0;
    }

    public Color getColor() {
        return this.color;
    }

    public Material getMaterial() {
        if (this.temperature > 505) {
            return Material.lava;
        }
        return super.getMaterial();
    }

    public void updateTick(World world, int x, int y, int z, Random rand) {
        float explosionSize;
        int flammability;
        super.updateTick(world, x, y, z, rand);
        if (this.getMaterial() == Material.lava) {
            int rangeUp = rand.nextInt(3);
            for (int i = 0; i < rangeUp; ++i) {
                Block block = world.getBlock(x += rand.nextInt(3) - 1, ++y, z += rand.nextInt(3) - 1);
                if (block.getMaterial() == Material.air) {
                    if (!BlockForestryFluid.isNeighborFlammable(world, x, y, z)) continue;
                    world.setBlock(x, y, z, (Block)Blocks.fire);
                    return;
                }
                if (!block.getMaterial().blocksMovement()) continue;
                return;
            }
            if (rangeUp == 0) {
                int startX = x;
                int startZ = z;
                for (int i = 0; i < 3; ++i) {
                    x = startX + rand.nextInt(3) - 1;
                    if (!world.isAirBlock(x, y + 1, z = startZ + rand.nextInt(3) - 1) || !BlockForestryFluid.isFlammable((IBlockAccess)world, x, y, z)) continue;
                    world.setBlock(x, y + 1, z, (Block)Blocks.fire);
                }
            }
        }
        if ((flammability = this.getFlammability((IBlockAccess)world, x, y, z, ForgeDirection.UNKNOWN)) > 0 && (double)(explosionSize = 4.0f * (float)flammability / 300.0f) > 1.0 && BlockForestryFluid.isNearFire(world, x, y, z)) {
            world.setBlock(x, y, z, (Block)Blocks.fire);
            world.newExplosion(null, (double)x, (double)y, (double)z, explosionSize, true, true);
        }
    }

    private static boolean isNeighborFlammable(World world, int x, int y, int z) {
        return BlockForestryFluid.isFlammable((IBlockAccess)world, x - 1, y, z) || BlockForestryFluid.isFlammable((IBlockAccess)world, x + 1, y, z) || BlockForestryFluid.isFlammable((IBlockAccess)world, x, y, z - 1) || BlockForestryFluid.isFlammable((IBlockAccess)world, x, y, z + 1) || BlockForestryFluid.isFlammable((IBlockAccess)world, x, y - 1, z) || BlockForestryFluid.isFlammable((IBlockAccess)world, x, y + 1, z);
    }

    private static boolean isNearFire(World world, int x, int y, int z) {
        AxisAlignedBB boundingBox = AxisAlignedBB.getBoundingBox((double)(x - 1), (double)(y - 1), (double)(z - 1), (double)(x + 1), (double)(y + 1), (double)(z + 1));
        return world.func_147470_e(boundingBox);
    }
}

