/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ICircuitLayout;
import forestry.core.circuits.ContainerSolderingIron;
import forestry.core.circuits.ItemSolderingIron;
import forestry.core.gui.GuiForestry;
import forestry.core.utils.StringUtil;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;

public class GuiSolderingIron
extends GuiForestry<ContainerSolderingIron, ItemSolderingIron.SolderingInventory> {
    public GuiSolderingIron(EntityPlayer player, ItemSolderingIron.SolderingInventory inventory) {
        super("textures/gui/solder.png", new ContainerSolderingIron(player, inventory), inventory);
        this.xSize = 176;
        this.ySize = 205;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(var1, mouseX, mouseY);
        ICircuitLayout layout = ((ContainerSolderingIron)this.inventorySlots).getLayout();
        String title = layout.getName();
        this.fontRendererObj.drawString(title, this.guiLeft + 8 + this.getCenteredOffset(title, 138), this.guiTop + 16, this.fontColor.get("gui.screen"));
        for (int l = 2; l < ((ItemSolderingIron.SolderingInventory)this.inventory).getSizeInventory(); ++l) {
            ItemSolderingIron.CircuitRecipe recipe = ItemSolderingIron.SolderManager.getMatchingRecipe(layout, ((ItemSolderingIron.SolderingInventory)this.inventory).getStackInSlot(l));
            String description = recipe == null ? "(" + StringUtil.localize("gui.noeffect") + ")" : StringUtil.localize(recipe.circuit.getName()) + " (" + recipe.circuit.getLimit() + ")";
            int row = (l - 2) * 20;
            this.fontRendererObj.drawString(description, this.guiLeft + 32, this.guiTop + 36 + row, this.fontColor.get("gui.screen"));
        }
    }

    public void initGui() {
        super.initGui();
        this.buttonList.add(new GuiButton(1, this.guiLeft + 12, this.guiTop + 10, 12, 18, "<"));
        this.buttonList.add(new GuiButton(2, this.guiLeft + 130, this.guiTop + 10, 12, 18, ">"));
    }

    protected void actionPerformed(GuiButton guibutton) {
        super.actionPerformed(guibutton);
        if (guibutton.id == 1) {
            ContainerSolderingIron.regressSelection(0);
        } else if (guibutton.id == 2) {
            ContainerSolderingIron.advanceSelection(0);
        }
    }
}

