/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.render;

import forestry.arboriculture.gadgets.ForestryBlockLeaves;
import forestry.arboriculture.gadgets.TileLeaves;
import forestry.arboriculture.genetics.TreeHelper;
import forestry.arboriculture.items.ItemLeavesBlock;
import forestry.core.proxy.Proxies;
import forestry.core.render.OverlayRenderingHandler;
import forestry.core.utils.StackUtils;
import forestry.plugins.PluginArboriculture;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class LeavesRenderingHandler
extends OverlayRenderingHandler
implements IItemRenderer {
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileLeaves tile = ForestryBlockLeaves.getLeafTile(world, x, y, z);
        if (tile == null) {
            return false;
        }
        renderer.renderStandardBlock(block, x, y, z);
        IIcon fruitIcon = tile.getFruitTexture();
        if (fruitIcon != null) {
            int fruitColor = tile.getFruitColour();
            LeavesRenderingHandler.renderFruitOverlay(world, block, x, y, z, renderer, fruitIcon, fruitColor);
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return PluginArboriculture.modelIdLeaves;
    }

    private static boolean renderFruitOverlay(IBlockAccess world, Block block, int x, int y, int z, RenderBlocks renderer, IIcon texture, int multiplier) {
        float mR = (float)(multiplier >> 16 & 0xFF) / 255.0f;
        float mG = (float)(multiplier >> 8 & 0xFF) / 255.0f;
        float mB = (float)(multiplier & 0xFF) / 255.0f;
        if (EntityRenderer.anaglyphEnable) {
            mR = (mR * 30.0f + mG * 59.0f + mB * 11.0f) / 100.0f;
            mG = (mR * 30.0f + mG * 70.0f) / 100.0f;
            mB = (mR * 30.0f + mB * 70.0f) / 100.0f;
        }
        return LeavesRenderingHandler.renderFruitOverlayWithColorMultiplier(world, block, x, y, z, mR, mG, mB, renderer, texture);
    }

    private static boolean renderFruitOverlayWithColorMultiplier(IBlockAccess world, Block block, int x, int y, int z, float r, float g, float b, RenderBlocks renderer, IIcon texture) {
        int mixedBrightness = block.getMixedBrightnessForBlock(world, x, y, z);
        float adjR = 0.5f * r;
        float adjG = 0.5f * g;
        float adjB = 0.5f * b;
        LeavesRenderingHandler.renderBottomFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        LeavesRenderingHandler.renderTopFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        LeavesRenderingHandler.renderEastFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        LeavesRenderingHandler.renderWestFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        LeavesRenderingHandler.renderNorthFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        LeavesRenderingHandler.renderSouthFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        return true;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: 
            case EQUIPPED_FIRST_PERSON: 
            case EQUIPPED: 
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                LeavesRenderingHandler.renderItem((RenderBlocks)data[0], item, 0.0f, 0.0f, 0.0f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: 
            case EQUIPPED: {
                LeavesRenderingHandler.renderItem((RenderBlocks)data[0], item, 0.5f, 0.5f, 0.5f);
                break;
            }
            case INVENTORY: {
                LeavesRenderingHandler.renderItem((RenderBlocks)data[0], item, 0.0f, 0.0f, 0.0f);
                break;
            }
        }
    }

    private static void renderItem(RenderBlocks renderer, ItemStack itemStack, float x, float y, float z) {
        Tessellator tessellator = Tessellator.instance;
        Block block = StackUtils.getBlock(itemStack);
        if (!(itemStack.getItem() instanceof ItemLeavesBlock) || block == null) {
            return;
        }
        TileLeaves leaves = new TileLeaves();
        if (itemStack.hasTagCompound()) {
            leaves.readFromNBT(itemStack.getTagCompound());
        } else {
            leaves.setTree(TreeHelper.treeTemplates.get(0));
        }
        GL11.glEnable((int)3042);
        IIcon leavesIcon = leaves.getIcon(Proxies.render.fancyGraphicsEnabled());
        if (leavesIcon == null) {
            return;
        }
        int color = leaves.getFoliageColour(Proxies.common.getPlayer());
        float r1 = (float)(color >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r1, (float)g1, (float)b1, (float)1.0f);
        GL11.glTranslatef((float)x, (float)y, (float)z);
        block.setBlockBoundsForItemRender();
        renderer.setRenderBoundsFromBlock(block);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderer.renderFaceYNeg(block, 0.0, 0.0, 0.0, leavesIcon);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderer.renderFaceYPos(block, 0.0, 0.0, 0.0, leavesIcon);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderer.renderFaceZNeg(block, 0.0, 0.0, 0.0, leavesIcon);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderer.renderFaceZPos(block, 0.0, 0.0, 0.0, leavesIcon);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderer.renderFaceXNeg(block, 0.0, 0.0, 0.0, leavesIcon);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderer.renderFaceXPos(block, 0.0, 0.0, 0.0, leavesIcon);
        tessellator.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        if (!leaves.hasFruit()) {
            return;
        }
        IIcon fruitTexture = leaves.getFruitTexture();
        if (fruitTexture == null) {
            return;
        }
        int fruitColor = leaves.getFruitColour();
        float r2 = (float)(fruitColor >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(fruitColor >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(fruitColor & 0xFF) / 255.0f;
        GL11.glColor4f((float)r2, (float)g2, (float)b2, (float)1.0f);
        block.setBlockBoundsForItemRender();
        renderer.setRenderBoundsFromBlock(block);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderer.renderFaceYNeg(block, 0.0, -0.001, 0.0, fruitTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderer.renderFaceYPos(block, 0.0, 0.001, 0.0, fruitTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderer.renderFaceZNeg(block, 0.0, 0.0, -0.001, fruitTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderer.renderFaceZPos(block, 0.0, 0.0, 0.001, fruitTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderer.renderFaceXNeg(block, -0.001, 0.0, 0.0, fruitTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderer.renderFaceXPos(block, 0.001, 0.0, 0.0, fruitTexture);
        tessellator.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }
}

