/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gadgets;

import forestry.api.arboriculture.IArboristTracker;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreekeepingMode;
import forestry.api.arboriculture.TreeManager;
import forestry.arboriculture.gadgets.TileTreeContainer;
import forestry.arboriculture.worldgen.WorldGenArboriculture;
import forestry.core.worldgen.WorldGenBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class TileSapling
extends TileTreeContainer {
    private int timesTicked = 0;

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.timesTicked = nbttagcompound.getInteger("TT");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setInteger("TT", this.timesTicked);
    }

    @Override
    public void onBlockTick() {
        ++this.timesTicked;
        this.tryGrow(false);
    }

    private static int getRequiredMaturity(World world, ITree tree) {
        ITreekeepingMode treekeepingMode = TreeManager.treeRoot.getTreekeepingMode(world);
        float maturationModifier = treekeepingMode.getMaturationModifier(tree.getGenome(), 1.0f);
        return Math.round((float)tree.getRequiredMaturity() * maturationModifier);
    }

    public boolean canAcceptBoneMeal() {
        ITree tree = this.getTree();
        if (tree == null) {
            return false;
        }
        int maturity = TileSapling.getRequiredMaturity(this.worldObj, tree);
        if (this.timesTicked < maturity) {
            return true;
        }
        WorldGenerator generator = tree.getTreeGenerator(this.worldObj, this.xCoord, this.yCoord, this.zCoord, true);
        if (generator instanceof WorldGenArboriculture) {
            WorldGenArboriculture arboricultureGenerator = (WorldGenArboriculture)generator;
            arboricultureGenerator.preGenerate(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
            return arboricultureGenerator.canGrow(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
        return true;
    }

    public void tryGrow(boolean bonemealed) {
        ITree tree = this.getTree();
        if (tree == null) {
            return;
        }
        int maturity = TileSapling.getRequiredMaturity(this.worldObj, tree);
        if (this.timesTicked < maturity) {
            if (bonemealed) {
                this.timesTicked = maturity;
            }
            return;
        }
        WorldGenerator generator = tree.getTreeGenerator(this.worldObj, this.xCoord, this.yCoord, this.zCoord, bonemealed);
        boolean generated = generator instanceof WorldGenBase ? ((WorldGenBase)generator).generate(this.worldObj, this.xCoord, this.yCoord, this.zCoord, bonemealed) : generator.generate(this.worldObj, this.worldObj.rand, this.xCoord, this.yCoord, this.zCoord);
        if (generated) {
            IArboristTracker breedingTracker = TreeManager.treeRoot.getBreedingTracker(this.worldObj, this.getOwner());
            breedingTracker.registerBirth(tree);
        }
    }
}

