/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import forestry.api.apiculture.DefaultBeeListener;
import forestry.api.apiculture.IAlvearyComponent;
import forestry.api.apiculture.IBeeListener;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.apiculture.multiblock.TileAlvearyWithGui;
import forestry.core.config.ForestryItem;
import forestry.core.interfaces.ICrafter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.GuiId;
import forestry.core.utils.StackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class TileAlvearySieve
extends TileAlvearyWithGui
implements ICrafter,
IAlvearyComponent.BeeListener {
    private final IBeeListener beeListener;
    private final AlvearySieveInventory inventory = new AlvearySieveInventory(this);

    public TileAlvearySieve() {
        super(7, GuiId.AlvearySieveGUI);
        this.beeListener = new AlvearySieveBeeListener(this);
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    public IBeeListener getBeeListener() {
        return this.beeListener;
    }

    @Override
    public int getIcon(int side) {
        if (side == 0 || side == 1) {
            return 2;
        }
        return 13;
    }

    @Override
    public boolean canTakeStack(int slotIndex) {
        return true;
    }

    @Override
    public ItemStack takenFromSlot(int slotIndex, EntityPlayer player) {
        return this.inventory.takenFromSlot(slotIndex);
    }

    @Override
    public ItemStack getResult() {
        return null;
    }

    public static class AlvearySieveInventory
    extends TileInventoryAdapter<TileAlvearySieve> {
        public static final int SLOT_POLLEN_1 = 0;
        public static final int SLOTS_POLLEN_COUNT = 4;
        public static final int SLOT_SIEVE = 4;

        public AlvearySieveInventory(TileAlvearySieve alvearySieve) {
            super(alvearySieve, 5, "Items", 1);
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            return StackUtils.isIdenticalItem(ForestryItem.craftingMaterial.getItemStack(1, 3), itemStack);
        }

        private boolean canStorePollen() {
            if (this.getStackInSlot(4) == null) {
                return false;
            }
            for (int i = 0; i < 4; ++i) {
                if (this.getStackInSlot(i) != null) continue;
                return true;
            }
            return false;
        }

        private void storePollenStack(ItemStack itemstack) {
            for (int i = 0; i < 4; ++i) {
                if (this.getStackInSlot(i) != null) continue;
                this.setInventorySlotContents(i, itemstack);
                return;
            }
        }

        public ItemStack takenFromSlot(int slotIndex) {
            if (slotIndex == 4) {
                for (int i = 0; i < 4; ++i) {
                    this.setInventorySlotContents(i, null);
                }
                return this.getStackInSlot(4);
            }
            this.setInventorySlotContents(4, null);
            return this.getStackInSlot(slotIndex);
        }
    }

    private static class AlvearySieveBeeListener
    extends DefaultBeeListener {
        private final TileAlvearySieve tile;

        public AlvearySieveBeeListener(TileAlvearySieve tile) {
            this.tile = tile;
        }

        @Override
        public boolean onPollenRetrieved(IIndividual pollen) {
            if (!this.tile.inventory.canStorePollen()) {
                return false;
            }
            ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(pollen.getClass());
            ItemStack pollenStack = speciesRoot.getMemberStack(pollen, EnumGermlingType.POLLEN.ordinal());
            if (pollenStack != null) {
                this.tile.inventory.storePollenStack(pollenStack);
                return true;
            }
            return false;
        }
    }
}

