/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleArea;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleTolerance;
import forestry.apiculture.genetics.BeeGenome;
import forestry.apiculture.items.ItemBeeGE;
import forestry.apiculture.items.ItemBeealyzer;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.alleles.AlleleBoolean;
import forestry.core.gui.ContainerAlyzer;
import forestry.core.gui.GuiAlyzer;
import forestry.core.gui.GuiForestry;
import forestry.core.utils.StringUtil;
import forestry.core.vect.Vect;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class GuiBeealyzer
extends GuiAlyzer {
    public GuiBeealyzer(EntityPlayer player, ItemBeealyzer.BeealyzerInventory inventory) {
        super("rootBees", player, new ContainerAlyzer(inventory, player), inventory, "gui.beealyzer");
        ArrayList beeList = new ArrayList();
        ((ItemBeeGE)ForestryItem.beeDroneGE.item()).addCreativeItems(beeList, false);
        for (ItemStack beeStack : beeList) {
            IAlleleBeeSpecies species = BeeGenome.getSpecies(beeStack);
            if (species == null) continue;
            this.iconStacks.put(species.getUID(), beeStack);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(var1, mouseX, mouseY);
        int page = 0;
        IBee bee = null;
        EnumBeeType beeType = EnumBeeType.DRONE;
        for (int k = 0; k <= 6; ++k) {
            if (k == 5 || this.inventory.getStackInSlot(k) == null) continue;
            bee = BeeManager.beeRoot.getMember(this.inventory.getStackInSlot(k));
            beeType = BeeManager.beeRoot.getType(this.inventory.getStackInSlot(k));
            if (bee == null || !bee.isAnalyzed()) continue;
            page = k;
            break;
        }
        switch (page) {
            case 1: {
                this.drawAnalyticsPage1(bee, beeType);
                break;
            }
            case 2: {
                this.drawAnalyticsPage2(bee, beeType);
                break;
            }
            case 3: {
                this.drawAnalyticsPage3(bee);
                break;
            }
            case 4: {
                this.drawAnalyticsPageMutations(bee);
                break;
            }
            case 6: {
                this.drawAnalyticsPageClassification(bee);
                break;
            }
            default: {
                this.drawAnalyticsOverview();
            }
        }
    }

    private void drawAnalyticsPage1(IBee bee, EnumBeeType type) {
        this.startPage(12, 90, 155);
        this.drawLine(StringUtil.localize("gui.active"), 90);
        this.drawLine(StringUtil.localize("gui.inactive"), 155);
        this.newLine();
        this.newLine();
        String customPrimaryBeeKey = "bees.custom.beealyzer." + type.getName() + "." + bee.getGenome().getPrimary().getUnlocalizedName().replace("bees.species.", "");
        String customSecondaryBeeKey = "bees.custom.beealyzer." + type.getName() + "." + bee.getGenome().getSecondary().getUnlocalizedName().replace("bees.species.", "");
        this.drawSpeciesRow(StringUtil.localize("gui.species"), bee, EnumBeeChromosome.SPECIES, GuiBeealyzer.checkCustomName(customPrimaryBeeKey), GuiBeealyzer.checkCustomName(customSecondaryBeeKey));
        this.newLine();
        this.drawChromosomeRow(StringUtil.localize("gui.lifespan"), bee, EnumBeeChromosome.LIFESPAN);
        this.newLine();
        this.drawChromosomeRow(StringUtil.localize("gui.speed"), bee, EnumBeeChromosome.SPEED);
        this.newLine();
        this.drawChromosomeRow(StringUtil.localize("gui.pollination"), bee, EnumBeeChromosome.FLOWERING);
        this.newLine();
        this.drawChromosomeRow(StringUtil.localize("gui.flowers"), bee, EnumBeeChromosome.FLOWER_PROVIDER);
        this.newLine();
        this.drawLine(StringUtil.localize("gui.fertility"), 12);
        IAlleleInteger primaryFertility = (IAlleleInteger)bee.getGenome().getActiveAllele(EnumBeeChromosome.FERTILITY);
        IAlleleInteger secondaryFertility = (IAlleleInteger)bee.getGenome().getInactiveAllele(EnumBeeChromosome.FERTILITY);
        this.drawFertilityInfo(primaryFertility.getValue(), 90, this.getColorCoding(primaryFertility.isDominant()), 0);
        this.drawFertilityInfo(secondaryFertility.getValue(), 155, this.getColorCoding(secondaryFertility.isDominant()), 0);
        this.newLine();
        IAlleleArea activeTerritory = (IAlleleArea)bee.getGenome().getActiveAllele(EnumBeeChromosome.TERRITORY);
        IAlleleArea inactiveTerritory = (IAlleleArea)bee.getGenome().getInactiveAllele(EnumBeeChromosome.TERRITORY);
        this.drawRow(StringUtil.localize("gui.area"), new Vect(activeTerritory.getValue()).toString(), new Vect(inactiveTerritory.getValue()).toString(), bee, EnumBeeChromosome.TERRITORY);
        this.newLine();
        this.drawChromosomeRow(StringUtil.localize("gui.effect"), bee, EnumBeeChromosome.EFFECT);
        this.newLine();
        this.endPage();
    }

    private void drawAnalyticsPage2(IBee bee, EnumBeeType type) {
        String displayText;
        String nocturnal1;
        String diurnal1;
        String nocturnal0;
        String diurnal0;
        this.startPage(12, 90, 155);
        this.drawLine(StringUtil.localize("gui.active"), 90);
        this.drawLine(StringUtil.localize("gui.inactive"), 155);
        this.newLine();
        this.drawRow(StringUtil.localize("gui.climate"), AlleleManager.climateHelper.toDisplay(bee.getGenome().getPrimary().getTemperature()), AlleleManager.climateHelper.toDisplay(bee.getGenome().getSecondary().getTemperature()), bee, EnumBeeChromosome.SPECIES);
        this.newLine();
        IAlleleTolerance tempToleranceActive = (IAlleleTolerance)bee.getGenome().getActiveAllele(EnumBeeChromosome.TEMPERATURE_TOLERANCE);
        IAlleleTolerance tempToleranceInactive = (IAlleleTolerance)bee.getGenome().getInactiveAllele(EnumBeeChromosome.TEMPERATURE_TOLERANCE);
        this.drawLine("  " + StringUtil.localize("gui.tolerance"), 12);
        this.drawToleranceInfo(tempToleranceActive, 90);
        this.drawToleranceInfo(tempToleranceInactive, 155);
        this.newLine(16);
        this.drawRow(StringUtil.localize("gui.humidity"), AlleleManager.climateHelper.toDisplay(bee.getGenome().getPrimary().getHumidity()), AlleleManager.climateHelper.toDisplay(bee.getGenome().getSecondary().getHumidity()), bee, EnumBeeChromosome.SPECIES);
        this.newLine();
        IAlleleTolerance humidToleranceActive = (IAlleleTolerance)bee.getGenome().getActiveAllele(EnumBeeChromosome.HUMIDITY_TOLERANCE);
        IAlleleTolerance humidToleranceInactive = (IAlleleTolerance)bee.getGenome().getInactiveAllele(EnumBeeChromosome.HUMIDITY_TOLERANCE);
        this.drawLine("  " + StringUtil.localize("gui.tolerance"), 12);
        this.drawToleranceInfo(humidToleranceActive, 90);
        this.drawToleranceInfo(humidToleranceInactive, 155);
        this.newLine(16);
        String yes = StringUtil.localize("yes");
        String no = StringUtil.localize("no");
        if (bee.getGenome().getNocturnal()) {
            nocturnal0 = diurnal0 = yes;
        } else {
            nocturnal0 = bee.getGenome().getPrimary().isNocturnal() ? yes : no;
            String string = diurnal0 = !bee.getGenome().getPrimary().isNocturnal() ? yes : no;
        }
        if (((AlleleBoolean)bee.getGenome().getInactiveAllele(EnumBeeChromosome.NOCTURNAL)).getValue()) {
            nocturnal1 = diurnal1 = yes;
        } else {
            nocturnal1 = bee.getGenome().getSecondary().isNocturnal() ? yes : no;
            diurnal1 = !bee.getGenome().getSecondary().isNocturnal() ? yes : no;
        }
        this.drawLine(StringUtil.localize("gui.diurnal"), 12);
        this.drawLine(diurnal0, 90, this.getColorCoding(false));
        this.drawLine(diurnal1, 155, this.getColorCoding(false));
        this.newLineCompressed();
        this.drawLine(StringUtil.localize("gui.nocturnal"), 12);
        this.drawLine(nocturnal0, 90, this.getColorCoding(false));
        this.drawLine(nocturnal1, 155, this.getColorCoding(false));
        this.newLineCompressed();
        String primary = StringUtil.readableBoolean(bee.getGenome().getTolerantFlyer(), yes, no);
        String secondary = StringUtil.readableBoolean(((AlleleBoolean)bee.getGenome().getInactiveAllele(EnumBeeChromosome.TOLERANT_FLYER)).getValue(), yes, no);
        this.drawRow(StringUtil.localize("gui.flyer"), primary, secondary, bee, EnumBeeChromosome.TOLERANT_FLYER);
        this.newLineCompressed();
        primary = StringUtil.readableBoolean(bee.getGenome().getCaveDwelling(), yes, no);
        secondary = StringUtil.readableBoolean(((AlleleBoolean)bee.getGenome().getInactiveAllele(EnumBeeChromosome.CAVE_DWELLING)).getValue(), yes, no);
        this.drawRow(StringUtil.localize("gui.cave"), primary, secondary, bee, EnumBeeChromosome.CAVE_DWELLING);
        this.newLine();
        if (type == EnumBeeType.PRINCESS || type == EnumBeeType.QUEEN) {
            displayText = "bees.stock.pristine";
            if (!bee.isNatural()) {
                displayText = "bees.stock.ignoble";
            }
            displayText = StringUtil.localize(displayText);
            this.drawCenteredLine(displayText, 8, 208, this.fontColor.get("gui.beealyzer.binomial"));
        }
        if (bee.getGeneration() >= 0) {
            this.newLineCompressed();
            displayText = StringUtil.localizeAndFormat("gui.beealyzer.generations", bee.getGeneration());
            this.drawCenteredLine(displayText, 8, 208, this.fontColor.get("gui.beealyzer.binomial"));
        }
        this.endPage();
    }

    private void drawAnalyticsPage3(IBee bee) {
        this.startPage(12, 90, 155);
        this.drawLine(StringUtil.localize("gui.beealyzer.produce") + ":", 12);
        this.newLine();
        int x = 12;
        for (ItemStack stack : bee.getProduceList()) {
            this.widgetManager.add(new GuiForestry.ItemStackWidget(x, this.getLineY(), stack));
            if ((x += 18) <= 148) continue;
            x = 12;
            this.newLine();
        }
        this.newLine();
        this.newLine();
        this.newLine();
        this.newLine();
        this.drawLine(StringUtil.localize("gui.beealyzer.specialty") + ":", 12);
        this.newLine();
        x = 12;
        for (ItemStack stack : bee.getSpecialtyList()) {
            this.widgetManager.add(new GuiForestry.ItemStackWidget(x, this.getLineY(), stack));
            if ((x += 18) <= 148) continue;
            x = 12;
            this.newLine();
        }
        this.endPage();
    }
}

