/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.AlleleEffectThrottled;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;

public class AlleleEffectResurrection
extends AlleleEffectThrottled {
    private final List<Resurrectable> resurrectables;

    public static List<Resurrectable> getReanimationList() {
        ArrayList<Resurrectable> list = new ArrayList<Resurrectable>();
        list.add(new Resurrectable(new ItemStack(Items.bone), EntitySkeleton.class));
        list.add(new Resurrectable(new ItemStack(Items.arrow), EntitySkeleton.class));
        list.add(new Resurrectable(new ItemStack(Items.rotten_flesh), EntityZombie.class));
        list.add(new Resurrectable(new ItemStack(Items.blaze_rod), EntityBlaze.class));
        return list;
    }

    public static List<Resurrectable> getResurrectionList() {
        ArrayList<Resurrectable> list = new ArrayList<Resurrectable>();
        list.add(new Resurrectable(new ItemStack(Items.gunpowder), EntityCreeper.class));
        list.add(new Resurrectable(new ItemStack(Items.ender_pearl), EntityEnderman.class));
        list.add(new Resurrectable(new ItemStack(Items.string), EntitySpider.class));
        list.add(new Resurrectable(new ItemStack(Items.spider_eye), EntitySpider.class));
        list.add(new Resurrectable(new ItemStack(Items.string), EntityCaveSpider.class));
        list.add(new Resurrectable(new ItemStack(Items.spider_eye), EntityCaveSpider.class));
        list.add(new Resurrectable(new ItemStack(Items.ghast_tear), EntityGhast.class));
        list.add(new Resurrectable(new ItemStack(Blocks.dragon_egg), EntityDragon.class));
        return list;
    }

    public AlleleEffectResurrection(String name, List<Resurrectable> resurrectables) {
        super(name, true, 40, true, true);
        this.resurrectables = resurrectables;
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        AxisAlignedBB bounding = this.getBounding(genome, housing);
        List list = housing.getWorld().getEntitiesWithinAABB(EntityItem.class, bounding);
        if (list.size() > 0) {
            Collections.shuffle(this.resurrectables);
        }
        block0: for (Object obj : list) {
            EntityItem item = (EntityItem)obj;
            if (item.isDead) continue;
            ItemStack contained = item.getEntityItem();
            for (Resurrectable entry : this.resurrectables) {
                if (!StackUtils.isIdenticalItem(entry.res, contained)) continue;
                Utils.spawnEntity(housing.getWorld(), entry.risen, item.posX, item.posY, item.posZ);
                --contained.stackSize;
                if (contained.stackSize > 0) continue block0;
                item.setDead();
                continue block0;
            }
        }
        return storedData;
    }

    public static class Resurrectable {
        public final ItemStack res;
        public final Class<? extends EntityLiving> risen;

        public Resurrectable(ItemStack res, Class<? extends EntityLiving> risen) {
            this.res = res;
            this.risen = risen;
        }
    }
}

