/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.AlleleEffectThrottled;
import forestry.core.proxy.Proxies;
import forestry.core.vect.Vect;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class AlleleEffectGlacial
extends AlleleEffectThrottled {
    public AlleleEffectGlacial() {
        super("glacial", false, 200, true, false);
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        EnumTemperature temp = housing.getTemperature();
        switch (temp) {
            case HELLISH: 
            case HOT: 
            case WARM: {
                return storedData;
            }
        }
        int[] areaAr = genome.getTerritory();
        Vect area = new Vect(areaAr);
        Vect offset = area.multiply(-0.5f);
        Vect housingCoords = new Vect(housing.getCoordinates());
        for (int i = 0; i < 10; ++i) {
            Vect randomPos = Vect.getRandomPositionInArea(world.rand, area);
            Vect posBlock = Vect.add(randomPos, housingCoords, offset);
            Block block = world.getBlock(posBlock.x, posBlock.y, posBlock.z);
            if (block != Blocks.water || !world.isAirBlock(posBlock.x, posBlock.y + 1, posBlock.z)) continue;
            Proxies.common.setBlockWithNotify(world, posBlock.x, posBlock.y, posBlock.z, Blocks.ice);
        }
        return storedData;
    }
}

