/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import forestry.api.apiculture.DefaultBeeListener;
import forestry.api.apiculture.DefaultBeeModifier;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.core.ForestryAPI;
import forestry.apiculture.gadgets.TileBeeHousing;
import forestry.core.network.GuiId;
import java.util.Collections;
import net.minecraft.entity.player.EntityPlayer;

public class TileBeehouse
extends TileBeeHousing {
    private static final IBeeModifier beeModifier = new BeehouseBeeModifier();
    private final IBeeListener beeListener = new DefaultBeeListener();
    private final IBeeHousingInventory beeInventory;

    public TileBeehouse() {
        TileBeeHousing.TileBeeHousingInventory beeHousingInventory = new TileBeeHousing.TileBeeHousingInventory(this, 12, "Items");
        beeHousingInventory.disableAutomation();
        this.beeInventory = beeHousingInventory;
        this.setInternalInventory(beeHousingInventory);
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return this.beeInventory;
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.BeehouseGUI.ordinal(), this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public Iterable<IBeeModifier> getBeeModifiers() {
        return Collections.singleton(beeModifier);
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.singleton(this.beeListener);
    }

    public static class BeehouseBeeModifier
    extends DefaultBeeModifier {
        @Override
        public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
            return 1.0f;
        }

        @Override
        public float getProductionModifier(IBeeGenome genome, float currentModifier) {
            return 0.25f;
        }

        @Override
        public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return 0.0f;
        }

        @Override
        public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            return 3.0f;
        }

        @Override
        public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
            return 3.0f;
        }

        @Override
        public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
            return 0.0f;
        }
    }
}

