/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import forestry.api.apiculture.BeeManager;
import forestry.core.config.ForestryBlock;
import forestry.core.gadgets.TileNaturalistChest;
import forestry.core.network.GuiId;
import forestry.core.utils.PlainInventory;
import forestry.core.utils.Utils;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public class TileApiaristChest
extends TileNaturalistChest {
    private boolean checkedForLegacyBlock = false;

    public TileApiaristChest() {
        super(BeeManager.beeRoot, GuiId.ApiaristChestGUI.ordinal());
    }

    @Override
    protected void updateServerSide() {
        if (this.worldObj != null && !this.checkedForLegacyBlock) {
            Block block = this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord);
            if (ForestryBlock.apiculture.isBlockEqual(block)) {
                this.migrateFromLegacyBlock();
            }
            this.checkedForLegacyBlock = true;
        }
    }

    private void migrateFromLegacyBlock() {
        PlainInventory inventoryCopy = new PlainInventory((IInventory)this.getInternalInventory());
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            this.setInventorySlotContents(i, null);
        }
        this.worldObj.setBlockToAir(this.xCoord, this.yCoord, this.zCoord);
        this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord, ForestryBlock.apicultureChest.block(), 0, 3);
        TileApiaristChest tile = Utils.getTile((IBlockAccess)this.worldObj, this.xCoord, this.yCoord, this.zCoord, TileApiaristChest.class);
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            ItemStack stack = inventoryCopy.getStackInSlot(i);
            tile.setInventorySlotContents(i, stack);
        }
        tile.markDirty();
    }
}

