/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import forestry.api.storage.IBackpackDefinition;
import forestry.core.interfaces.IPickupHandler;
import forestry.storage.gui.ContainerBackpack;
import forestry.storage.gui.ContainerNaturalistBackpack;
import forestry.storage.items.ItemBackpack;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class PickupHandlerStorage
implements IPickupHandler {
    @Override
    public boolean onItemPickup(EntityPlayer player, EntityItem entityitem) {
        ItemStack itemstack = entityitem.getEntityItem();
        if (itemstack == null || itemstack.stackSize <= 0) {
            return false;
        }
        if (player.openContainer instanceof ContainerBackpack || player.openContainer instanceof ContainerNaturalistBackpack) {
            return false;
        }
        PickupHandlerStorage.topOffPlayerInventory(player, itemstack);
        for (ItemStack pack : player.inventory.mainInventory) {
            ItemBackpack backpack;
            IBackpackDefinition backpackDefinition;
            if (pack == null || pack.stackSize <= 0) continue;
            if (itemstack.stackSize <= 0) break;
            if (!(pack.getItem() instanceof ItemBackpack) || !(backpackDefinition = (backpack = (ItemBackpack)pack.getItem()).getDefinition()).isValidItem(itemstack)) continue;
            ItemBackpack.tryStowing(player, pack, itemstack);
        }
        return itemstack.stackSize == 0;
    }

    private static void topOffPlayerInventory(EntityPlayer player, ItemStack itemstack) {
        for (int i = 0; i < player.inventory.getSizeInventory(); ++i) {
            ItemStack inventoryStack = player.inventory.getStackInSlot(i);
            if (inventoryStack == null || inventoryStack.stackSize >= inventoryStack.getMaxStackSize() || !inventoryStack.isItemEqual(itemstack) || !ItemStack.areItemStackTagsEqual((ItemStack)inventoryStack, (ItemStack)itemstack)) continue;
            int space = inventoryStack.getMaxStackSize() - inventoryStack.stackSize;
            if (space > itemstack.stackSize) {
                inventoryStack.stackSize += itemstack.stackSize;
                itemstack.stackSize = 0;
                break;
            }
            inventoryStack.stackSize = inventoryStack.getMaxStackSize();
            itemstack.stackSize -= space;
        }
    }
}

