/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import forestry.api.storage.IBackpackDefinition;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.OreDictionary;

public class BackpackDefinition
implements IBackpackDefinition {
    private final String name;
    private final int primaryColor;
    private final int secondaryColor;
    private final Set<String> validItemStacks = new HashSet<String>();
    private final Set<Integer> validOreIds = new HashSet<Integer>();
    private final Set<Class> validItemClasses = new HashSet<Class>();
    private final Set<Class> validBlockClasses = new HashSet<Class>();

    public BackpackDefinition(String name, int primaryColor) {
        this(name, primaryColor, 0xFFFFFF);
    }

    public BackpackDefinition(String name, int primaryColor, int secondaryColor) {
        this.name = name;
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
    }

    @Override
    public String getKey() {
        return this.name;
    }

    @Override
    public String getName(ItemStack backpack) {
        NBTTagCompound nbt;
        Item item = backpack.getItem();
        String display = ("" + StatCollector.translateToLocal((String)(item.getUnlocalizedNameInefficiently(backpack) + ".name"))).trim();
        if (backpack.stackTagCompound != null && backpack.stackTagCompound.hasKey("display", 10) && (nbt = backpack.stackTagCompound.getCompoundTag("display")).hasKey("Name", 8)) {
            display = nbt.getString("Name");
        }
        return display;
    }

    @Override
    public int getPrimaryColour() {
        return this.primaryColor;
    }

    @Override
    public int getSecondaryColour() {
        return this.secondaryColor;
    }

    @Override
    public void addValidItem(ItemStack validItem) {
        if (validItem == null) {
            return;
        }
        Item item = validItem.getItem();
        if (item == null) {
            return;
        }
        String itemStackString = item.delegate.name();
        int meta = validItem.getItemDamage();
        if (meta != Short.MAX_VALUE) {
            itemStackString = itemStackString + ':' + meta;
        }
        this.validItemStacks.add(itemStackString);
    }

    public void clearAllValid() {
        this.validItemStacks.clear();
        this.validOreIds.clear();
    }

    @Override
    public void addValidItems(List<ItemStack> validItems) {
        for (ItemStack validItem : validItems) {
            this.addValidItem(validItem);
        }
    }

    public void addValidOreDictName(String oreDictName) {
        int oreId = OreDictionary.getOreID((String)oreDictName);
        this.validOreIds.add(oreId);
    }

    public void addValidOreDictNames(List<String> oreDictNames) {
        for (String oreDictName : oreDictNames) {
            this.addValidOreDictName(oreDictName);
        }
    }

    public void addValidItemClass(Class itemClass) {
        if (itemClass != null) {
            this.validItemClasses.add(itemClass);
        }
    }

    public void addValidItemClasses(List<Class> itemClasses) {
        for (Class itemClass : itemClasses) {
            this.addValidItemClass(itemClass);
        }
    }

    public void addValidBlockClass(Class blockClass) {
        if (blockClass != null) {
            this.validBlockClasses.add(blockClass);
        }
    }

    public void addValidBlockClasses(List<Class> blockClasses) {
        for (Class blockClass : blockClasses) {
            this.addValidBlockClass(blockClass);
        }
    }

    public Set<String> getValidItemStacks() {
        return this.validItemStacks;
    }

    public Set<Integer> getValidOreIds() {
        return this.validOreIds;
    }

    public Set<Class> getValidBlockClasses() {
        return this.validBlockClasses;
    }

    public Set<Class> getValidItemClasses() {
        return this.validItemClasses;
    }

    @Override
    public boolean isValidItem(ItemStack itemStack) {
        int[] oreIds;
        String itemStackString;
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.getItem();
        if (item == null) {
            return false;
        }
        String itemStackStringWild = item.delegate.name();
        if (this.validItemStacks.contains(itemStackStringWild)) {
            return true;
        }
        int meta = itemStack.getItemDamage();
        if (meta != Short.MAX_VALUE && this.validItemStacks.contains(itemStackString = itemStackStringWild + ':' + meta)) {
            return true;
        }
        for (int oreId : oreIds = OreDictionary.getOreIDs((ItemStack)itemStack)) {
            if (!this.validOreIds.contains(oreId)) continue;
            this.validItemStacks.add(itemStackStringWild);
            return true;
        }
        for (Class itemClass : this.validItemClasses) {
            if (!itemClass.isInstance(item)) continue;
            this.validItemStacks.add(itemStackStringWild);
            return true;
        }
        Block block = Block.getBlockFromItem((Item)item);
        if (block != null) {
            for (Class blockClass : this.validBlockClasses) {
                if (!blockClass.isInstance(block)) continue;
                this.validItemStacks.add(itemStackStringWild);
                return true;
            }
        }
        return false;
    }
}

