/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gadgets;

import buildcraft.api.statements.ITriggerExternal;
import cpw.mods.fml.common.Optional;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IStamps;
import forestry.api.mail.PostManager;
import forestry.core.EnumErrorCode;
import forestry.core.gadgets.TileBase;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StackUtils;
import forestry.mail.MailAddress;
import forestry.mail.TradeStation;
import forestry.mail.network.PacketTraderAddress;
import forestry.mail.triggers.MailTriggers;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineTrader
extends TileBase {
    private IMailAddress address = new MailAddress();

    public MachineTrader() {
        this.setInternalInventory(new TradeStation.TradeStationInventory());
    }

    @Override
    public void openGui(EntityPlayer player) {
        if (this.isLinked()) {
            player.openGui(ForestryAPI.instance, GuiId.TraderGUI.ordinal(), this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        } else {
            player.openGui(ForestryAPI.instance, GuiId.TraderNameGUI.ordinal(), this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public void onRemoval() {
        if (this.isLinked()) {
            PostManager.postRegistry.deleteTradeStation(this.worldObj, this.address);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (this.address != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.address.writeToNBT(nbt);
            nbttagcompound.setTag("address", (NBTBase)nbt);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.hasKey("address")) {
            this.address = MailAddress.loadFromNBT(nbttagcompound.getCompoundTag("address"));
        }
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        String name = null;
        if (this.address != null) {
            name = this.address.getName();
        }
        if (name == null) {
            name = "";
        }
        data.writeUTF(name);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        String address = data.readUTF();
        if (address.length() > 0) {
            this.address = PostManager.postRegistry.getMailAddress(address);
        }
    }

    @Override
    public void updateServerSide() {
        if (!this.isLinked() || !this.updateOnInterval(10)) {
            return;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!this.hasPostageMin(3), EnumErrorCode.NOSTAMPS);
        errorLogic.setCondition(!this.hasPaperMin(2), EnumErrorCode.NOPAPER);
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack tradeGood = inventory.getStackInSlot(0);
        errorLogic.setCondition(tradeGood == null, EnumErrorCode.NOTRADE);
        boolean hasRequest = this.hasItemCount(1, 4, null, 1);
        errorLogic.setCondition(!hasRequest, EnumErrorCode.NOTRADE);
        if (tradeGood != null) {
            boolean hasSupplies = this.hasItemCount(30, 10, tradeGood, tradeGood.stackSize);
            errorLogic.setCondition(!hasSupplies, EnumErrorCode.NOSUPPLIES);
        }
        if (inventory instanceof TradeStation && this.updateOnInterval(200)) {
            boolean canReceivePayment = ((TradeStation)inventory).canReceivePayment();
            errorLogic.setCondition(!canReceivePayment, EnumErrorCode.NOSPACE);
        }
    }

    public boolean isLinked() {
        if (this.address == null || !this.address.isValid()) {
            return false;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        return !errorLogic.contains(EnumErrorCode.NOTALPHANUMERIC) && !errorLogic.contains(EnumErrorCode.NOTUNIQUE);
    }

    private boolean hasItemCount(int startSlot, int countSlots, ItemStack item, int itemCount) {
        int count = 0;
        IInventoryAdapter tradeInventory = this.getInternalInventory();
        for (int i = startSlot; i < startSlot + countSlots; ++i) {
            ItemStack itemInSlot = tradeInventory.getStackInSlot(i);
            if (itemInSlot == null) continue;
            if (item == null || StackUtils.isIdenticalItem(itemInSlot, item)) {
                count += itemInSlot.stackSize;
            }
            if (count < itemCount) continue;
            return true;
        }
        return false;
    }

    private float percentOccupied(int startSlot, int countSlots, ItemStack item) {
        int count = 0;
        int total = 0;
        IInventoryAdapter tradeInventory = this.getInternalInventory();
        for (int i = startSlot; i < startSlot + countSlots; ++i) {
            ItemStack itemInSlot = tradeInventory.getStackInSlot(i);
            if (itemInSlot == null) {
                total += 64;
                continue;
            }
            total += itemInSlot.getMaxStackSize();
            if (item != null && !StackUtils.isIdenticalItem(itemInSlot, item)) continue;
            count += itemInSlot.stackSize;
        }
        return (float)count / (float)total;
    }

    public boolean hasPaperMin(int count) {
        return this.hasItemCount(5, 6, new ItemStack(Items.paper), count);
    }

    public boolean hasInputBufMin(float percentage) {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack tradeGood = inventory.getStackInSlot(0);
        if (tradeGood == null) {
            return true;
        }
        return this.percentOccupied(30, 10, tradeGood) > percentage;
    }

    public boolean hasOutputBufMin(float percentage) {
        return this.percentOccupied(15, 15, null) > percentage;
    }

    public boolean hasPostageMin(int postage) {
        int posted = 0;
        IInventoryAdapter tradeInventory = this.getInternalInventory();
        for (int i = 11; i < 15; ++i) {
            ItemStack stamp = tradeInventory.getStackInSlot(i);
            if (stamp == null || !(stamp.getItem() instanceof IStamps) || (posted += ((IStamps)stamp.getItem()).getPostage(stamp).getValue() * stamp.stackSize) < postage) continue;
            return true;
        }
        return false;
    }

    public IMailAddress getAddress() {
        return this.address;
    }

    public void handleSetAddress(String addressName) {
        String newAddressName;
        IMailAddress newAddress;
        IMailAddress address = PostManager.postRegistry.getMailAddress(addressName);
        this.setAddress(address);
        if (!this.worldObj.isRemote && (newAddress = this.getAddress()) != null && (newAddressName = newAddress.getName()) != null && newAddressName.equals(addressName)) {
            PacketTraderAddress packetResponse = new PacketTraderAddress(this, addressName);
            Proxies.net.sendNetworkPacket(packetResponse, this.worldObj);
        }
    }

    private void setAddress(IMailAddress address) {
        if (address == null) {
            throw new NullPointerException("address must not be null");
        }
        if (this.address != null && this.address.isValid() && this.address.equals(address)) {
            return;
        }
        if (Proxies.common.isSimulating(this.worldObj)) {
            IErrorLogic errorLogic = this.getErrorLogic();
            boolean hasValidTradeAddress = PostManager.postRegistry.isValidTradeAddress(this.worldObj, address);
            errorLogic.setCondition(!hasValidTradeAddress, EnumErrorCode.NOTALPHANUMERIC);
            boolean hasUniqueTradeAddress = PostManager.postRegistry.isAvailableTradeAddress(this.worldObj, address);
            errorLogic.setCondition(!hasUniqueTradeAddress, EnumErrorCode.NOTUNIQUE);
            if (hasValidTradeAddress & hasUniqueTradeAddress) {
                this.address = address;
                PostManager.postRegistry.getOrCreateTradeStation(this.worldObj, this.getAccessHandler().getOwner(), address);
            }
        } else {
            this.address = address;
        }
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        if (!Proxies.common.isSimulating(this.worldObj) || !this.address.isValid()) {
            return super.getInternalInventory();
        }
        return (TradeStation)PostManager.postRegistry.getOrCreateTradeStation(this.worldObj, this.getAccessHandler().getOwner(), this.address);
    }

    @Override
    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        LinkedList<ITriggerExternal> res = new LinkedList<ITriggerExternal>();
        res.add(MailTriggers.lowPaper64);
        res.add(MailTriggers.lowPaper32);
        res.add(MailTriggers.lowInput25);
        res.add(MailTriggers.lowInput10);
        res.add(MailTriggers.lowPostage40);
        res.add(MailTriggers.lowPostage20);
        res.add(MailTriggers.highBuffer90);
        res.add(MailTriggers.highBuffer75);
        return res;
    }
}

