/*
 * Decompiled with CFR 0.152.
 */
package forestry.food.items;

import forestry.api.core.ForestryAPI;
import forestry.api.food.BeverageManager;
import forestry.api.food.IBeverageEffect;
import forestry.api.food.IInfuserManager;
import forestry.api.food.IIngredientManager;
import forestry.core.CreativeTabForestry;
import forestry.core.config.ForestryItem;
import forestry.core.inventory.ItemInventory;
import forestry.core.items.ItemForestry;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.food.BeverageEffect;
import forestry.food.items.ItemBeverage;
import forestry.plugins.PluginManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemInfuser
extends ItemForestry {
    public ItemInfuser() {
        this.setMaxStackSize(1);
        this.setCreativeTab(CreativeTabForestry.tabForestry);
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (Proxies.common.isSimulating(world)) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.InfuserGUI.ordinal(), world, (int)entityplayer.posX, (int)entityplayer.posY, (int)entityplayer.posZ);
        }
        return itemstack;
    }

    public static void initialize() {
        if (PluginManager.Module.APICULTURE.isEnabled()) {
            BeverageManager.ingredientManager.addIngredient(ForestryItem.pollenCluster.getItemStack(1, 0), "Strong Curative");
            BeverageManager.ingredientManager.addIngredient(ForestryItem.pollenCluster.getItemStack(1, 1), "Weak Curative");
            BeverageManager.infuserManager.addMixture(1, ForestryItem.pollenCluster.getItemStack(1, 0), BeverageEffect.strongAntidote);
            BeverageManager.infuserManager.addMixture(1, ForestryItem.pollenCluster.getItemStack(1, 1), BeverageEffect.weakAntidote);
        }
    }

    public static class InfuserInventory
    extends ItemInventory {
        private static final short inputSlot = 0;
        private static final short outputSlot = 1;
        private static final short ingredientSlot1 = 2;
        private static final short ingredientSlotCount = 4;

        public InfuserInventory(EntityPlayer player, ItemStack itemStack) {
            super(player, 6, itemStack);
        }

        @Override
        public void onSlotClick(EntityPlayer player) {
            ItemStack[] toRemove;
            ItemStack input = this.getStackInSlot(0);
            if (input == null) {
                return;
            }
            if (this.getStackInSlot(1) != null) {
                return;
            }
            if (!input.isItemEqual(ForestryItem.beverage.getItemStack())) {
                return;
            }
            ItemStack[] ingredients = new ItemStack[4];
            for (int i = 0; i < 4; ++i) {
                ingredients[i] = this.getStackInSlot(i + 2);
            }
            if (!BeverageManager.infuserManager.hasMixtures(ingredients)) {
                return;
            }
            ItemStack seasoned = BeverageManager.infuserManager.getSeasoned(input, ingredients);
            if (seasoned == null) {
                return;
            }
            block1: for (ItemStack templ : toRemove = BeverageManager.infuserManager.getRequired(ingredients)) {
                ItemStack ghost = templ.copy();
                for (int i = 2; i < this.getSizeInventory(); ++i) {
                    ItemStack ingredient = this.getStackInSlot(i);
                    if (ingredient == null) continue;
                    if (ghost.stackSize <= 0) continue block1;
                    if ((ghost.getItemDamage() < 0 || !ingredient.isItemEqual(ghost)) && (ghost.getItemDamage() >= 0 || ghost.getItem() != ingredient.getItem())) continue;
                    ItemStack removed = this.decrStackSize(i, 1);
                    ghost.stackSize -= removed.stackSize;
                }
            }
            this.decrStackSize(0, 1);
            this.setInventorySlotContents(1, seasoned);
        }

        @Override
        public String getInventoryName() {
            return "Infuser";
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 0) {
                return ForestryItem.beverage.isItemEqual(itemStack);
            }
            if (slotIndex >= 2 && slotIndex < 6) {
                return BeverageManager.infuserManager.isIngredient(itemStack);
            }
            return false;
        }
    }

    public static class IngredientManager
    implements IIngredientManager {
        private final ArrayList<Ingredient> ingredients = new ArrayList();

        @Override
        public void addIngredient(ItemStack ingredient, String description) {
            this.ingredients.add(new Ingredient(ingredient, description));
        }

        @Override
        public String getDescription(ItemStack itemstack) {
            if (itemstack == null) {
                return null;
            }
            for (Ingredient ingredient : this.ingredients) {
                if (ingredient.ingredient.getItemDamage() < 0 && ingredient.ingredient.getItem() == itemstack.getItem()) {
                    return ingredient.description;
                }
                if (ingredient.ingredient.getItemDamage() < 0 || !ingredient.ingredient.isItemEqual(itemstack)) continue;
                return ingredient.description;
            }
            return null;
        }
    }

    public static class Ingredient {
        public final ItemStack ingredient;
        public final String description;

        public Ingredient(ItemStack ingredient, String description) {
            this.ingredient = ingredient;
            this.description = description;
        }
    }

    public static class MixtureManager
    implements IInfuserManager {
        private final ArrayList<Mixture> mixtures = new ArrayList();

        @Override
        public void addMixture(int meta, ItemStack ingredient, IBeverageEffect effect) {
            this.mixtures.add(new Mixture(meta, ingredient, effect));
        }

        @Override
        public void addMixture(int meta, ItemStack[] ingredients, IBeverageEffect effect) {
            this.mixtures.add(new Mixture(meta, ingredients, effect));
        }

        @Override
        public boolean isIngredient(ItemStack itemstack) {
            for (Mixture ingredient : this.mixtures) {
                if (!ingredient.isIngredient(itemstack)) continue;
                return true;
            }
            return false;
        }

        private Mixture[] getMatchingMixtures(ItemStack[] ingredients) {
            ArrayList<Mixture> matches = new ArrayList<Mixture>();
            for (Mixture mixture : this.mixtures) {
                if (!mixture.matches(ingredients)) continue;
                matches.add(mixture);
            }
            return matches.toArray(new Mixture[matches.size()]);
        }

        @Override
        public boolean hasMixtures(ItemStack[] ingredients) {
            return this.getMatchingMixtures(ingredients).length > 0;
        }

        @Override
        public ItemStack[] getRequired(ItemStack[] ingredients) {
            Mixture[] mixtures = this.getMatchingMixtures(ingredients);
            ArrayList<ItemStack> required = new ArrayList<ItemStack>();
            for (Mixture mixture : mixtures) {
                required.addAll(Arrays.asList(mixture.getIngredients()));
            }
            return required.toArray(new ItemStack[required.size()]);
        }

        @Override
        public ItemStack getSeasoned(ItemStack base, ItemStack[] ingredients) {
            Mixture[] mixtures = this.getMatchingMixtures(ingredients);
            List<IBeverageEffect> effects = ItemBeverage.BeverageInfo.loadEffects(base);
            int weight = 0;
            int meta = 0;
            for (Mixture mixture : mixtures) {
                effects.add(mixture.getEffect());
                if (mixture.getWeight() <= weight) continue;
                weight = mixture.getWeight();
                meta = mixture.getMeta();
            }
            ItemStack seasoned = base.copy();
            seasoned.setItemDamage(meta);
            ItemBeverage.BeverageInfo.saveEffects(seasoned, effects);
            return seasoned;
        }
    }

    public static class Mixture {
        private final int meta;
        private final ItemStack[] ingredients;
        private final IBeverageEffect effect;

        public Mixture(int meta, ItemStack ingredient, IBeverageEffect effect) {
            this(meta, new ItemStack[]{ingredient}, effect);
        }

        public Mixture(int meta, ItemStack[] ingredients, IBeverageEffect effect) {
            this.meta = meta;
            this.ingredients = ingredients;
            this.effect = effect;
        }

        public ItemStack[] getIngredients() {
            return this.ingredients;
        }

        public boolean isIngredient(ItemStack itemstack) {
            for (ItemStack ingredient : this.ingredients) {
                if (ingredient.getItemDamage() < 0 && ingredient.getItem() == itemstack.getItem()) {
                    return true;
                }
                if (ingredient.getItemDamage() < 0 || !ingredient.isItemEqual(itemstack)) continue;
                return true;
            }
            return false;
        }

        public boolean matches(ItemStack[] res) {
            if (res == null || res.length <= 0) {
                return false;
            }
            boolean matchedAll = true;
            for (ItemStack stack : this.ingredients) {
                boolean matched = false;
                for (ItemStack matchStack : res) {
                    if (matchStack == null) continue;
                    if (stack.getItemDamage() < 0 && stack.getItem() == matchStack.getItem()) {
                        if (stack.stackSize > matchStack.stackSize) continue;
                        matched = true;
                        break;
                    }
                    if (stack.getItemDamage() < 0 || !stack.isItemEqual(matchStack) || stack.stackSize > matchStack.stackSize) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                matchedAll = false;
            }
            return matchedAll;
        }

        public IBeverageEffect getEffect() {
            return this.effect;
        }

        public int getMeta() {
            return this.meta;
        }

        public int getWeight() {
            return this.ingredients.length;
        }
    }
}

