/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmLogic;
import forestry.core.render.SpriteSheet;
import forestry.core.vect.Vect;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class FarmLogic
implements IFarmLogic {
    protected final IFarmHousing housing;
    protected boolean isManual;

    protected FarmLogic(IFarmHousing housing) {
        this.housing = housing;
    }

    @Override
    public FarmLogic setManual(boolean flag) {
        this.isManual = flag;
        return this;
    }

    protected World getWorld() {
        return this.housing.getWorld();
    }

    @Override
    public ResourceLocation getSpriteSheet() {
        return SpriteSheet.ITEMS.getLocation();
    }

    protected final boolean isAirBlock(Block block) {
        return block.getMaterial() == Material.air;
    }

    protected final boolean isWaterSourceBlock(World world, Vect position) {
        return world.getBlock(position.x, position.y, position.z) == Blocks.water && world.getBlockMetadata(position.x, position.y, position.z) == 0;
    }

    protected final Vect translateWithOffset(int x, int y, int z, FarmDirection farmDirection, int step) {
        return new Vect(farmDirection.getForgeDirection()).multiply(step).add(x, y, z);
    }

    protected final void setBlock(Vect position, Block block, int meta) {
        this.getWorld().setBlock(position.x, position.y, position.z, block, meta, 3);
    }
}

