/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import buildcraft.api.statements.ITriggerExternal;
import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.Optional;
import forestry.api.core.ForestryAPI;
import forestry.api.recipes.ICentrifugeManager;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.TilePowered;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.GuiId;
import forestry.core.utils.GuiUtil;
import forestry.core.utils.StackUtils;
import forestry.factory.triggers.FactoryTriggers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineCentrifuge
extends TilePowered
implements ISidedInventory {
    public static final int SLOT_RESOURCE = 0;
    public static final int SLOT_PRODUCT_1 = 1;
    public static final int SLOT_PRODUCT_COUNT = 9;
    private ICentrifugeRecipe currentRecipe;
    private final Stack<ItemStack> pendingProducts = new Stack();
    private int productionTime;
    private int timePerItem;

    public MachineCentrifuge() {
        super(800, 40, 5000);
        this.setInternalInventory(new CentrifugeInventoryAdapter(this));
        this.setHints(Config.hints.get("centrifuge"));
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.CentrifugeGUI.ordinal(), player.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setInteger("ProductionTime", this.productionTime);
        nbttagcompound.setInteger("TimePerItem", this.timePerItem);
        NBTTagList nbttaglist = new NBTTagList();
        ItemStack[] offspring = this.pendingProducts.toArray(new ItemStack[this.pendingProducts.size()]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setByte("Slot", (byte)i);
            offspring[i].writeToNBT(nbttagcompound1);
            nbttaglist.appendTag((NBTBase)nbttagcompound1);
        }
        nbttagcompound.setTag("PendingProducts", (NBTBase)nbttaglist);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.productionTime = nbttagcompound.getInteger("ProductionTime");
        this.timePerItem = nbttagcompound.getInteger("TimePerItem");
        NBTTagList nbttaglist = nbttagcompound.getTagList("PendingProducts", 10);
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.getCompoundTagAt(i);
            this.pendingProducts.add(ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound1));
        }
        this.checkRecipe();
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (!this.updateOnInterval(20)) {
            return;
        }
        this.checkRecipe();
    }

    @Override
    public boolean workCycle() {
        this.checkRecipe();
        if (this.tryAddPending()) {
            return false;
        }
        if (!this.pendingProducts.isEmpty()) {
            return false;
        }
        if (this.productionTime <= 0) {
            return false;
        }
        if (this.currentRecipe == null) {
            return false;
        }
        --this.productionTime;
        if (this.productionTime > 0) {
            return true;
        }
        Collection<ItemStack> products = this.currentRecipe.getProducts(this.worldObj.rand);
        this.pendingProducts.addAll(products);
        this.getInternalInventory().decrStackSize(0, 1);
        this.checkRecipe();
        this.resetRecipeTimes();
        this.tryAddPending();
        return true;
    }

    private void checkRecipe() {
        ICentrifugeRecipe machingRecipe = RecipeManager.findMatchingRecipe(this.getInternalInventory().getStackInSlot(0));
        if (this.currentRecipe != machingRecipe) {
            this.currentRecipe = machingRecipe;
            this.resetRecipeTimes();
        }
        this.getErrorLogic().setCondition(this.currentRecipe == null, EnumErrorCode.NORECIPE);
    }

    private void resetRecipeTimes() {
        if (this.currentRecipe == null) {
            this.productionTime = 0;
            this.timePerItem = 0;
            return;
        }
        this.productionTime = this.currentRecipe.getProcessingTime();
        this.timePerItem = this.currentRecipe.getProcessingTime();
    }

    private boolean tryAddPending() {
        if (this.pendingProducts.isEmpty()) {
            return false;
        }
        ItemStack next = this.pendingProducts.peek();
        boolean added = InvTools.tryAddStack((IInventory)this, next, 1, 9, true);
        if (added) {
            this.pendingProducts.pop();
        }
        this.getErrorLogic().setCondition(!added, EnumErrorCode.NOSPACE);
        return added;
    }

    @Override
    public boolean isWorking() {
        return this.currentRecipe != null;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.getStackInSlot(0) == null) {
            return false;
        }
        return (float)inventory.getStackInSlot((int)0).stackSize / (float)inventory.getStackInSlot(0).getMaxStackSize() > percentage;
    }

    @Override
    public boolean hasWork() {
        return this.currentRecipe != null;
    }

    public int getProgressScaled(int i) {
        if (this.timePerItem == 0) {
            return i;
        }
        return (this.timePerItem - this.productionTime) * i / this.timePerItem;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.productionTime = j;
                break;
            }
            case 1: {
                this.timePerItem = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.sendProgressBarUpdate(container, 0, this.productionTime);
        iCrafting.sendProgressBarUpdate(container, 1, this.timePerItem);
    }

    @Override
    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        LinkedList<ITriggerExternal> res = new LinkedList<ITriggerExternal>();
        res.add(FactoryTriggers.lowResource25);
        res.add(FactoryTriggers.lowResource10);
        return res;
    }

    public static class RecipeManager
    implements ICentrifugeManager {
        public static final List<ICentrifugeRecipe> recipes = new ArrayList<ICentrifugeRecipe>();

        @Override
        public void addRecipe(ICentrifugeRecipe recipe) {
            recipes.add(recipe);
        }

        @Override
        public void addRecipe(int timePerItem, ItemStack resource, Map<ItemStack, Float> products) {
            CentrifugeRecipe recipe = new CentrifugeRecipe(timePerItem, resource, products);
            this.addRecipe(recipe);
        }

        public static ICentrifugeRecipe findMatchingRecipe(ItemStack item) {
            for (ICentrifugeRecipe recipe : recipes) {
                ItemStack recipeInput = recipe.getInput();
                if (!StackUtils.isCraftingEquivalent(recipeInput, item)) continue;
                return recipe;
            }
            return null;
        }

        @Override
        public Map<Object[], Object[]> getRecipes() {
            HashMap<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();
            for (ICentrifugeRecipe recipe : recipes) {
                Set<ItemStack> productsKeys = recipe.getAllProducts().keySet();
                recipeList.put(new Object[]{recipe.getInput()}, productsKeys.toArray(new ItemStack[productsKeys.size()]));
            }
            return recipeList;
        }
    }

    public static class CentrifugeRecipe
    implements ICentrifugeRecipe {
        private final int processingTime;
        private final ItemStack input;
        private final Map<ItemStack, Float> outputs;

        public CentrifugeRecipe(int processingTime, ItemStack input, Map<ItemStack, Float> outputs) {
            this.processingTime = processingTime;
            this.input = input;
            this.outputs = outputs;
            for (ItemStack item : outputs.keySet()) {
                if (item != null) continue;
                throw new IllegalArgumentException("Tried to register a null product of " + input);
            }
        }

        @Override
        public ItemStack getInput() {
            return this.input;
        }

        @Override
        public int getProcessingTime() {
            return this.processingTime;
        }

        @Override
        public Collection<ItemStack> getProducts(Random random) {
            ArrayList<ItemStack> products = new ArrayList<ItemStack>();
            for (Map.Entry<ItemStack, Float> entry : this.outputs.entrySet()) {
                float probability = entry.getValue().floatValue();
                if ((double)probability >= 1.0) {
                    products.add(entry.getKey().copy());
                    continue;
                }
                if (!(random.nextFloat() < probability)) continue;
                products.add(entry.getKey().copy());
            }
            return products;
        }

        @Override
        public Map<ItemStack, Float> getAllProducts() {
            return ImmutableMap.copyOf(this.outputs);
        }
    }

    private static class CentrifugeInventoryAdapter
    extends TileInventoryAdapter<MachineCentrifuge> {
        public CentrifugeInventoryAdapter(MachineCentrifuge centrifuge) {
            super(centrifuge, 10, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            return slotIndex == 0 && RecipeManager.findMatchingRecipe(itemStack) != null;
        }

        @Override
        public boolean canExtractItem(int slotIndex, ItemStack itemstack, int side) {
            return GuiUtil.isIndexInRange(slotIndex, 1, 9);
        }
    }
}

