/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class PlainInventory
implements IInventory {
    private final ItemStack[] contents;
    private final String name;
    private final int stackLimit;

    public PlainInventory(int size, String name) {
        this(size, name, 64);
    }

    public PlainInventory(int size, String name, int stackLimit) {
        this.contents = new ItemStack[size];
        this.name = name;
        this.stackLimit = stackLimit;
    }

    public PlainInventory(IInventory tocopy) {
        this(tocopy.getSizeInventory(), tocopy.getInventoryName(), tocopy.getInventoryStackLimit());
        for (int i = 0; i < tocopy.getSizeInventory(); ++i) {
            if (tocopy.getStackInSlot(i) != null) {
                this.setInventorySlotContents(i, tocopy.getStackInSlot(i).copy());
                continue;
            }
            this.setInventorySlotContents(i, null);
        }
    }

    public ItemStack[] getContents() {
        return this.contents;
    }

    public int getSizeInventory() {
        return this.contents.length;
    }

    public ItemStack getStackInSlot(int slotId) {
        return this.contents[slotId];
    }

    public ItemStack decrStackSize(int slotId, int count) {
        if (this.contents[slotId] == null) {
            return null;
        }
        if (this.contents[slotId].stackSize > count) {
            return this.contents[slotId].splitStack(count);
        }
        ItemStack stack = this.contents[slotId];
        this.contents[slotId] = null;
        return stack;
    }

    public void setInventorySlotContents(int slotId, ItemStack itemstack) {
        this.contents[slotId] = itemstack;
    }

    public String getInventoryName() {
        return this.name;
    }

    public int getInventoryStackLimit() {
        return this.stackLimit;
    }

    public void markDirty() {
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return false;
    }

    public ItemStack getStackInSlotOnClosing(int slotIndex) {
        return this.getStackInSlot(slotIndex);
    }

    public boolean hasCustomInventoryName() {
        return true;
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }
}

