/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorLogicSource;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketId;
import forestry.core.proxy.Proxies;
import java.io.IOException;
import net.minecraft.tileentity.TileEntity;

public class PacketErrorUpdate
extends PacketCoordinates {
    private IErrorLogic errorLogic;

    public static void onPacketData(DataInputStreamForestry data) throws IOException {
        new PacketErrorUpdate(data);
    }

    private PacketErrorUpdate(DataInputStreamForestry data) throws IOException {
        super(data);
    }

    public PacketErrorUpdate(TileEntity tile, IErrorLogicSource errorLogicSource) {
        super(PacketId.TILE_FORESTRY_ERROR_UPDATE, tile);
        this.errorLogic = errorLogicSource.getErrorLogic();
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.errorLogic.writeData(data);
    }

    @Override
    protected void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        TileEntity tile = this.getTarget(Proxies.common.getRenderWorld());
        if (tile instanceof IErrorLogicSource) {
            IErrorLogicSource errorSourceTile = (IErrorLogicSource)tile;
            this.errorLogic = errorSourceTile.getErrorLogic();
            this.errorLogic.readData(data);
        }
    }
}

