/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.CreativeTabForestry;
import forestry.core.render.TextureManager;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class BlockStainedGlass
extends BlockBreakable {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public BlockStainedGlass() {
        super("", Material.glass, true);
        this.setHardness(0.3f);
        this.setStepSound(soundTypeGlass);
        this.setCreativeTab(CreativeTabForestry.tabForestry);
    }

    public void getSubBlocks(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        for (int i = 0; i < 16; ++i) {
            itemList.add(new ItemStack((Block)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.icons = new IIcon[16];
        for (int i = 0; i < 16; ++i) {
            this.icons[i] = TextureManager.getInstance().registerTex(register, "stained/" + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return this.icons[15 - meta];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        return this.getIcon(side, world.getBlockMetadata(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int meta) {
        Block block = world.getBlock(x, y, z);
        return block != this && super.shouldSideBeRendered(world, x, y, z, meta);
    }

    public int damageDropped(int meta) {
        return meta;
    }

    public int quantityDropped(Random rand) {
        return 0;
    }

    public int getRenderBlockPass() {
        return 1;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    protected boolean canSilkHarvest() {
        return true;
    }
}

