/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitLayout;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class CircuitBoard<T>
implements ICircuitBoard {
    private EnumCircuitBoardType type;
    private ICircuitLayout layout;
    private ICircuit[] circuits;

    public CircuitBoard(EnumCircuitBoardType type, ICircuitLayout layout, ICircuit[] circuits) {
        this.type = type;
        this.layout = layout;
        this.circuits = circuits;
    }

    public CircuitBoard(NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound);
    }

    @Override
    public int getPrimaryColor() {
        return this.type.primaryColor;
    }

    @Override
    public int getSecondaryColor() {
        return this.type.secondaryColor;
    }

    @Override
    public void addTooltip(List<String> list) {
        if (this.layout != null) {
            list.add(EnumChatFormatting.GOLD + this.layout.getUsage() + ":");
        }
        ArrayList<String> extendedTooltip = new ArrayList<String>();
        for (ICircuit circuit : this.circuits) {
            if (circuit == null) continue;
            circuit.addTooltip(extendedTooltip);
        }
        if (Proxies.common.isShiftDown() || extendedTooltip.size() <= 4) {
            list.addAll(extendedTooltip);
        } else {
            list.add(EnumChatFormatting.ITALIC + "<" + StringUtil.localize("gui.tooltip.tmi") + ">");
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.type = EnumCircuitBoardType.values()[nbttagcompound.getShort("T")];
        if (nbttagcompound.hasKey("LY")) {
            this.layout = ChipsetManager.circuitRegistry.getLayout(nbttagcompound.getString("LY"));
        }
        if (this.layout == null) {
            ChipsetManager.circuitRegistry.getDefaultLayout();
        }
        ArrayList<ICircuit> readcircuits = new ArrayList<ICircuit>();
        if (this.circuits != null) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            ICircuit circuit;
            if (!nbttagcompound.hasKey("CA.I" + i) || (circuit = ChipsetManager.circuitRegistry.getCircuit(nbttagcompound.getString("CA.I" + i))) == null) continue;
            readcircuits.add(circuit);
        }
        this.circuits = readcircuits.toArray(new ICircuit[readcircuits.size()]);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setShort("T", (short)this.type.ordinal());
        if (this.layout != null) {
            nbttagcompound.setString("LY", this.layout.getUID());
        }
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            nbttagcompound.setString("CA.I" + i, circuit.getUID());
        }
    }

    @Override
    public void onInsertion(Object tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            circuit.onInsertion(i, tile);
        }
    }

    @Override
    public void onLoad(Object tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            circuit.onLoad(i, tile);
        }
    }

    @Override
    public void onRemoval(Object tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            circuit.onRemoval(i, tile);
        }
    }

    @Override
    public void onTick(Object tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            circuit.onTick(i, tile);
        }
    }

    @Override
    public ICircuit[] getCircuits() {
        return this.circuits;
    }
}

