/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

public enum TemperatureState {
    UNKNOWN,
    COOL,
    WARMED_UP,
    OPERATING_TEMPERATURE,
    RUNNING_HOT,
    OVERHEATING,
    MELTING;


    public static TemperatureState getState(double heat, double maxHeat) {
        double scaledHeat = heat / maxHeat;
        if (scaledHeat < 0.2) {
            return COOL;
        }
        if (scaledHeat < 0.45) {
            return WARMED_UP;
        }
        if (scaledHeat < 0.65) {
            return OPERATING_TEMPERATURE;
        }
        if (scaledHeat < 0.85) {
            return RUNNING_HOT;
        }
        if (scaledHeat < 1.0) {
            return OVERHEATING;
        }
        return MELTING;
    }
}

