/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import cpw.mods.fml.common.network.IGuiHandler;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.gadgets.TileNaturalistChest;
import forestry.core.gui.ContainerNaturalistInventory;
import forestry.core.gui.GuiNaturalistInventory;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketGuiUpdate;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class GuiHandlerBase
implements IGuiHandler {
    protected static <T extends TileEntity> T getTile(World world, int x, int y, int z, EntityPlayer player, Class<T> tileClass) {
        T tileForestry = Utils.getTile((IBlockAccess)world, x, y, z, tileClass);
        if (tileForestry instanceof IStreamableGui && !world.isRemote) {
            PacketGuiUpdate packet = new PacketGuiUpdate((IStreamableGui)tileForestry);
            Proxies.net.sendToPlayer(packet, player);
        }
        return tileForestry;
    }

    protected GuiNaturalistInventory getNaturalistChestGui(String rootUID, EntityPlayer player, World world, int x, int y, int z, int page) {
        TileNaturalistChest tile = GuiHandlerBase.getTile(world, x, y, z, player, TileNaturalistChest.class);
        ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(rootUID);
        return new GuiNaturalistInventory(speciesRoot, player, new ContainerNaturalistInventory(player.inventory, tile, page), tile, page, 5);
    }

    protected ContainerNaturalistInventory getNaturalistChestContainer(String rootUID, EntityPlayer player, World world, int x, int y, int z, int page) {
        ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(rootUID);
        speciesRoot.getBreedingTracker(world, player.getGameProfile()).synchToPlayer(player);
        return new ContainerNaturalistInventory(player.inventory, GuiHandlerBase.getTile(world, x, y, z, player, TileNaturalistChest.class), page);
    }

    public static int encodeGuiData(int guiId, int data) {
        return data << 8 | guiId;
    }

    protected static int decodeGuiID(int guiId) {
        return guiId & 0xFF;
    }

    protected static int decodeGuiData(int guiId) {
        return guiId >> 8;
    }
}

