/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import com.mojang.authlib.GameProfile;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.gadgets.TileTreeContainer;
import forestry.arboriculture.worldgen.ITreeBlockType;
import forestry.arboriculture.worldgen.TreeBlockType;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.core.utils.Utils;
import forestry.core.worldgen.BlockType;
import forestry.core.worldgen.BlockTypeVoid;
import forestry.core.worldgen.WorldGenBase;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class WorldGenArboriculture
extends WorldGenBase {
    private static final ITreeBlockType vineNorth = new TreeBlockType(Blocks.vine, 1);
    private static final ITreeBlockType vineSouth = new TreeBlockType(Blocks.vine, 4);
    private static final ITreeBlockType vineWest = new TreeBlockType(Blocks.vine, 8);
    private static final ITreeBlockType vineEast = new TreeBlockType(Blocks.vine, 2);
    private static final int minPodHeight = 3;
    private static final BlockType air = new BlockTypeVoid();
    protected final ITreeGenData tree;
    private int startX;
    private int startY;
    private int startZ;
    protected TreeBlockTypeLeaf leaf;
    protected ITreeBlockType wood;
    private boolean spawnPods = false;

    protected WorldGenArboriculture(ITreeGenData tree) {
        this.tree = tree;
    }

    @Override
    public boolean generate(World world, int x, int y, int z, boolean forced) {
        this.spawnPods = this.tree.allowsFruitBlocks();
        this.leaf = this.getLeaf(WorldGenArboriculture.getOwner(world, x, y, z));
        this.wood = this.getWood();
        this.preGenerate(world, x, y, z);
        if (forced || this.canGrow(world, x, y, z)) {
            this.generate(world);
            return true;
        }
        return false;
    }

    private static GameProfile getOwner(World world, int x, int y, int z) {
        TileTreeContainer tile = Utils.getTile((IBlockAccess)world, x, y, z, TileTreeContainer.class);
        if (tile == null) {
            return null;
        }
        return tile.getOwner();
    }

    public void preGenerate(World world, int startX, int startY, int startZ) {
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
    }

    protected abstract void generate(World var1);

    public abstract boolean canGrow(World var1, int var2, int var3, int var4);

    protected abstract TreeBlockTypeLeaf getLeaf(GameProfile var1);

    protected abstract ITreeBlockType getWood();

    protected void generateTreeTrunk(World world, int height, int girth) {
        this.generateTreeTrunk(world, height, girth, 0.0f);
    }

    protected void generateTreeTrunk(World world, int height, int girth, float vines) {
        int offset = (girth - 1) / 2;
        for (int x = 0; x < girth; ++x) {
            for (int z = 0; z < girth; ++z) {
                for (int y = 0; y < height; ++y) {
                    this.addWood(world, x - offset, y, z - offset, WorldGenBase.EnumReplaceMode.ALL);
                    this.addVines(world, x - offset, y, z - offset, vines);
                }
            }
        }
        if (!this.spawnPods) {
            return;
        }
        this.generatePods(world, height, girth);
    }

    protected void generatePods(World world, int height, int girth) {
        for (int y = 3; y < height; ++y) {
            for (int x = 0; x < girth; ++x) {
                for (int z = 0; z < girth; ++z) {
                    if (x > 0 && x < girth && z > 0 && z < girth) continue;
                    this.tree.trySpawnFruitBlock(world, this.startX + x + 1, this.startY + y, this.startZ + z);
                    this.tree.trySpawnFruitBlock(world, this.startX + x - 1, this.startY + y, this.startZ + z);
                    this.tree.trySpawnFruitBlock(world, this.startX + x, this.startY + y, this.startZ + z + 1);
                    this.tree.trySpawnFruitBlock(world, this.startX + x, this.startY + y, this.startZ + z - 1);
                }
            }
        }
    }

    protected void generateSupportStems(World world, int height, int girth, float chance, float maxHeight) {
        int offset = 1;
        for (int x = -offset; x < girth + offset; ++x) {
            for (int z = -offset; z < girth + offset; ++z) {
                if (x == -offset && z == -offset || x == girth + offset && z == girth + offset || x == -offset && z == girth + offset || x == girth + offset && z == -offset) continue;
                int stemHeight = world.rand.nextInt(Math.round((float)height * maxHeight));
                if (!(world.rand.nextFloat() < chance)) continue;
                for (int i = 0; i < stemHeight; ++i) {
                    this.addWood(world, x, i, z, WorldGenBase.EnumReplaceMode.SOFT);
                }
            }
        }
    }

    @Override
    protected void addBlock(World world, int x, int y, int z, ITreeBlockType type, WorldGenBase.EnumReplaceMode replace) {
        if (replace == WorldGenBase.EnumReplaceMode.ALL || replace == WorldGenBase.EnumReplaceMode.SOFT && Utils.isReplaceableBlock(world, this.startX + x, this.startY + y, this.startZ + z) || world.isAirBlock(this.startX + x, this.startY + y, this.startZ + z)) {
            type.setBlock(world, this.tree, this.startX + x, this.startY + y, this.startZ + z);
        }
    }

    protected final void clearBlock(World world, int x, int y, int z) {
        air.setBlock(world, this.startX + x, this.startY + y, this.startZ + z);
    }

    protected final void addWood(World world, int x, int y, int z, WorldGenBase.EnumReplaceMode replace) {
        this.addBlock(world, x, y, z, this.wood, replace);
    }

    protected final void addLeaf(World world, int x, int y, int z, WorldGenBase.EnumReplaceMode replace) {
        this.addBlock(world, x, y, z, this.leaf, replace);
    }

    protected final void addVine(World world, int x, int y, int z, ITreeBlockType vine) {
        this.addBlock(world, x, y, z, vine, WorldGenBase.EnumReplaceMode.NONE);
    }

    protected final void addVines(World world, int x, int y, int z, float chance) {
        if (chance <= 0.0f) {
            return;
        }
        if (world.rand.nextFloat() < chance) {
            this.addVine(world, x - 1, y, z, vineWest);
        }
        if (world.rand.nextFloat() < chance) {
            this.addVine(world, x + 1, y, z, vineEast);
        }
        if (world.rand.nextFloat() < chance) {
            this.addVine(world, x, y, z - 1, vineNorth);
        }
        if (world.rand.nextFloat() < chance) {
            this.addVine(world, x, y, z + 1, vineSouth);
        }
    }
}

