/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class TextureHabitatLocator
extends TextureAtlasSprite {
    private static TextureHabitatLocator instance;
    private ChunkCoordinates targetBiome;
    private boolean targetBiomeFound;
    private double currentAngle;
    private double angleDelta;

    public static TextureHabitatLocator getInstance() {
        return instance;
    }

    public TextureHabitatLocator(String iconName) {
        super(iconName);
        instance = this;
    }

    public void setTargetCoordinates(ChunkCoordinates coordinates) {
        this.targetBiome = coordinates;
        this.targetBiomeFound = false;
    }

    public void updateAnimation() {
        Minecraft minecraft = Minecraft.getMinecraft();
        if (minecraft.theWorld != null && minecraft.thePlayer != null) {
            this.updateCompass((World)minecraft.theWorld, minecraft.thePlayer.posX, minecraft.thePlayer.posZ, minecraft.thePlayer.rotationYaw);
        } else {
            this.updateCompass(null, 0.0, 0.0, 0.0);
        }
    }

    private void updateCompass(World world, double playerX, double playerZ, double playerYaw) {
        double angleChange;
        double targetAngle;
        if (world == null || this.targetBiome == null) {
            targetAngle = Math.random() * Math.PI * 2.0;
        } else {
            double xPart = (double)this.targetBiome.posX - playerX;
            double zPart = (double)this.targetBiome.posZ - playerZ;
            if (Math.abs(xPart) + Math.abs(zPart) < 10.0 || this.targetBiomeFound) {
                targetAngle = this.currentAngle + 1.0;
                this.targetBiomeFound = true;
            } else {
                targetAngle = -(((playerYaw %= 360.0) - 90.0) * Math.PI / 180.0 - Math.atan2(zPart, xPart));
            }
        }
        for (angleChange = targetAngle - this.currentAngle; angleChange < -Math.PI; angleChange += Math.PI * 2) {
        }
        while (angleChange >= Math.PI) {
            angleChange -= Math.PI * 2;
        }
        if (angleChange < -1.0) {
            angleChange = -1.0;
        }
        if (angleChange > 1.0) {
            angleChange = 1.0;
        }
        this.angleDelta += angleChange * 0.1;
        this.angleDelta *= 0.8;
        this.currentAngle += this.angleDelta;
        int i = (int)((this.currentAngle / (Math.PI * 2) + 1.0) * (double)this.framesTextureData.size()) % this.framesTextureData.size();
        while (i < 0) {
            i = (i + this.framesTextureData.size()) % this.framesTextureData.size();
        }
        if (i != this.frameCounter) {
            this.frameCounter = i;
            TextureUtil.uploadTextureMipmap((int[][])((int[][])this.framesTextureData.get(this.frameCounter)), (int)this.width, (int)this.height, (int)this.originX, (int)this.originY, (boolean)false, (boolean)false);
        }
    }
}

