/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.proxy;

import cpw.mods.fml.client.registry.RenderingRegistry;
import forestry.apiculture.entities.EntityBee;
import forestry.apiculture.proxy.ProxyApiculture;
import forestry.apiculture.render.BeeItemRenderer;
import forestry.apiculture.render.EntityBeeFX;
import forestry.apiculture.render.ParticleRenderer;
import forestry.apiculture.render.RenderBee;
import forestry.core.config.ForestryItem;
import forestry.core.interfaces.IBlockRenderer;
import forestry.core.proxy.ClientProxyRender;
import forestry.core.render.RenderAnalyzer;
import forestry.core.render.TextureManager;
import forestry.plugins.PluginApiculture;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.item.Item;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

public class ClientProxyApiculture
extends ProxyApiculture {
    @Override
    public void initializeRendering() {
        if (PluginApiculture.fancyRenderedBees) {
            RenderingRegistry.registerEntityRenderingHandler(EntityBee.class, (Render)new RenderBee());
            MinecraftForgeClient.registerItemRenderer((Item)ForestryItem.beeDroneGE.item(), (IItemRenderer)new BeeItemRenderer());
            MinecraftForgeClient.registerItemRenderer((Item)ForestryItem.beePrincessGE.item(), (IItemRenderer)new BeeItemRenderer());
            MinecraftForgeClient.registerItemRenderer((Item)ForestryItem.beeQueenGE.item(), (IItemRenderer)new BeeItemRenderer());
        }
    }

    @Override
    public void addBeeHiveFX(String icon, World world, ChunkCoordinates coordinates, int color) {
        if (!ClientProxyRender.shouldSpawnParticle(world)) {
            return;
        }
        EntityBeeFX fx = new EntityBeeFX(world, (double)coordinates.posX + 0.5, (double)coordinates.posY + 0.5, (double)coordinates.posZ + 0.5, color);
        fx.setParticleIcon(TextureManager.getInstance().getDefault(icon));
        ParticleRenderer.getInstance().addEffect(fx);
    }

    @Override
    public void addBeeSwarmFX(String icon, World world, double xCoord, double yCoord, double zCoord, int color) {
        EntityBeeFX fx;
        if (!ClientProxyRender.shouldSpawnParticle(world)) {
            return;
        }
        if (world.rand.nextBoolean()) {
            fx = new EntityBeeFX(world, xCoord, yCoord, zCoord, color);
        } else {
            double spawnX = xCoord + (double)world.rand.nextInt(4) - 2.0;
            double spawnY = yCoord + (double)world.rand.nextInt(4) - 2.0;
            double spawnZ = zCoord + (double)world.rand.nextInt(4) - 2.0;
            fx = new EntityBeeFX(world, spawnX, spawnY, spawnZ, color);
        }
        fx.setParticleIcon(TextureManager.getInstance().getDefault(icon));
        ParticleRenderer.getInstance().addEffect(fx);
    }

    @Override
    public IBlockRenderer getRendererAnalyzer(String gfxBase) {
        return new RenderAnalyzer(gfxBase);
    }
}

